/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.telemetry;

import com.google.common.base.Suppliers;
import com.mojang.authlib.minecraft.TelemetrySession;
import com.mojang.authlib.minecraft.UserApiService;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.telemetry.TelemetryEventInstance;
import net.minecraft.client.telemetry.TelemetryEventLogger;
import net.minecraft.client.telemetry.TelemetryEventSender;
import net.minecraft.client.telemetry.TelemetryEventType;
import net.minecraft.client.telemetry.TelemetryLogManager;
import net.minecraft.client.telemetry.TelemetryProperty;
import net.minecraft.client.telemetry.TelemetryPropertyMap;
import net.minecraft.client.telemetry.WorldSessionTelemetryManager;

public class ClientTelemetryManager
implements AutoCloseable {
    private static final AtomicInteger f_260680_ = new AtomicInteger(1);
    private static final Executor f_260581_ = Executors.newSingleThreadExecutor(p_261485_ -> {
        Thread $$1 = new Thread(p_261485_);
        $$1.setName("Telemetry-Sender-#" + f_260680_.getAndIncrement());
        return $$1;
    });
    private final UserApiService f_260615_;
    private final TelemetryPropertyMap f_260661_;
    private final Path f_260682_;
    private final CompletableFuture<Optional<TelemetryLogManager>> f_260616_;
    private final Supplier<TelemetryEventSender> f_285581_ = Suppliers.memoize(this::m_261052_);

    public ClientTelemetryManager(Minecraft p_261610_, UserApiService p_261552_, User p_262159_) {
        this.f_260615_ = p_261552_;
        TelemetryPropertyMap.Builder $$3 = TelemetryPropertyMap.m_261098_();
        p_262159_.m_193806_().ifPresent(p_261810_ -> $$3.m_261137_(TelemetryProperty.f_260659_, p_261810_));
        p_262159_.m_193805_().ifPresent(p_261690_ -> $$3.m_261137_(TelemetryProperty.f_260475_, p_261690_));
        $$3.m_261137_(TelemetryProperty.f_260530_, UUID.randomUUID());
        $$3.m_261137_(TelemetryProperty.f_260597_, SharedConstants.m_183709_().m_132492_());
        $$3.m_261137_(TelemetryProperty.f_260441_, Util.m_137581_().m_183999_());
        $$3.m_261137_(TelemetryProperty.f_260586_, System.getProperty("os.name"));
        $$3.m_261137_(TelemetryProperty.f_260562_, Minecraft.m_193589_().m_184597_());
        $$3.m_285763_(TelemetryProperty.f_285658_, System.getProperty("minecraft.launcher.brand"));
        this.f_260661_ = $$3.m_260981_();
        this.f_260682_ = p_261610_.f_91069_.toPath().resolve("logs/telemetry");
        this.f_260616_ = TelemetryLogManager.m_261252_(this.f_260682_);
    }

    public WorldSessionTelemetryManager m_285995_(boolean p_286373_, @Nullable Duration p_286752_, @Nullable String p_286568_) {
        return new WorldSessionTelemetryManager(this.m_261052_(), p_286373_, p_286752_, p_286568_);
    }

    public TelemetryEventSender m_285963_() {
        return this.f_285581_.get();
    }

    private TelemetryEventSender m_261052_() {
        if (SharedConstants.f_136183_) {
            return TelemetryEventSender.f_260501_;
        }
        TelemetrySession $$0 = this.f_260615_.newTelemetrySession(f_260581_);
        if (!$$0.isEnabled()) {
            return TelemetryEventSender.f_260501_;
        }
        CompletionStage $$1 = this.f_260616_.thenCompose(p_261737_ -> p_261737_.map(TelemetryLogManager::m_260856_).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty())));
        return (arg_0, arg_1) -> this.m_260889_((CompletableFuture)$$1, $$0, arg_0, arg_1);
    }

    public Path m_260914_() {
        return this.f_260682_;
    }

    @Override
    public void close() {
        this.f_260616_.thenAccept(p_261643_ -> p_261643_.ifPresent(TelemetryLogManager::close));
    }

    private /* synthetic */ void m_260889_(CompletableFuture p_261935_, TelemetrySession p_261928_, TelemetryEventType p_261827_, Consumer p_261818_) {
        if (p_261827_.m_260839_() && !Minecraft.m_91087_().m_260979_()) {
            return;
        }
        TelemetryPropertyMap.Builder $$4 = TelemetryPropertyMap.m_261098_();
        $$4.m_260832_(this.f_260661_);
        $$4.m_261137_(TelemetryProperty.f_260726_, Instant.now());
        $$4.m_261137_(TelemetryProperty.f_260453_, p_261827_.m_260839_());
        p_261818_.accept($$4);
        TelemetryEventInstance $$5 = new TelemetryEventInstance(p_261827_, $$4.m_260981_());
        p_261935_.thenAccept(p_262038_ -> {
            if (p_262038_.isEmpty()) {
                return;
            }
            ((TelemetryEventLogger)p_262038_.get()).m_260877_($$5);
            $$5.m_261105_(p_261928_).send();
        });
    }
}

