/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components.tabs;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.TabButton;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class TabNavigationBar
extends AbstractContainerEventHandler
implements Renderable,
GuiEventListener,
NarratableEntry {
    private static final int f_268741_ = -1;
    private static final int f_273832_ = 400;
    private static final int f_273831_ = 24;
    private static final int f_273887_ = 14;
    private static final Component f_273890_ = Component.m_237115_("narration.tab_navigation.usage");
    private final GridLayout f_273942_;
    private int f_267467_;
    private final TabManager f_267401_;
    private final ImmutableList<Tab> f_267380_;
    private final ImmutableList<TabButton> f_267495_;

    TabNavigationBar(int p_275379_, TabManager p_275624_, Iterable<Tab> p_275279_) {
        this.f_267467_ = p_275379_;
        this.f_267401_ = p_275624_;
        this.f_267380_ = ImmutableList.copyOf(p_275279_);
        this.f_273942_ = new GridLayout(0, 0);
        this.f_273942_.m_264211_().m_264356_();
        ImmutableList.Builder $$3 = ImmutableList.builder();
        int $$4 = 0;
        for (Tab $$5 : p_275279_) {
            $$3.add((Object)this.f_273942_.m_264379_(new TabButton(p_275624_, $$5, 0, 24), 0, $$4++));
        }
        this.f_267495_ = $$3.build();
    }

    public static Builder m_267630_(TabManager p_268126_, int p_268070_) {
        return new Builder(p_268126_, p_268070_);
    }

    public void m_267604_(int p_268094_) {
        this.f_267467_ = p_268094_;
    }

    @Override
    public void m_93692_(boolean p_275488_) {
        super.m_93692_(p_275488_);
        if (this.m_7222_() != null) {
            this.m_7222_().m_93692_(p_275488_);
        }
    }

    @Override
    public void m_7522_(@Nullable GuiEventListener p_275675_) {
        super.m_7522_(p_275675_);
        if (p_275675_ instanceof TabButton) {
            TabButton $$1 = (TabButton)p_275675_;
            this.f_267401_.m_276088_($$1.m_274356_(), true);
        }
    }

    @Override
    @Nullable
    public ComponentPath m_264064_(FocusNavigationEvent p_275418_) {
        TabButton $$1;
        if (!this.m_93696_() && ($$1 = this.m_274517_()) != null) {
            return ComponentPath.m_264334_(this, ComponentPath.m_264401_($$1));
        }
        if (p_275418_ instanceof FocusNavigationEvent.TabNavigation) {
            return null;
        }
        return super.m_264064_(p_275418_);
    }

    @Override
    public List<? extends GuiEventListener> m_6702_() {
        return this.f_267495_;
    }

    @Override
    public NarratableEntry.NarrationPriority m_142684_() {
        return this.f_267495_.stream().map(AbstractWidget::m_142684_).max(Comparator.naturalOrder()).orElse(NarratableEntry.NarrationPriority.NONE);
    }

    @Override
    public void m_142291_(NarrationElementOutput p_275583_) {
        Optional<TabButton> $$1 = this.f_267495_.stream().filter(AbstractWidget::m_274382_).findFirst().or(() -> Optional.ofNullable(this.m_274517_()));
        $$1.ifPresent(p_274663_ -> {
            this.m_274560_(p_275583_.m_142047_(), (TabButton)p_274663_);
            p_274663_.m_142291_(p_275583_);
        });
        if (this.m_93696_()) {
            p_275583_.m_169146_(NarratedElementType.USAGE, f_273890_);
        }
    }

    protected void m_274560_(NarrationElementOutput p_275386_, TabButton p_275397_) {
        int $$2;
        if (this.f_267380_.size() > 1 && ($$2 = this.f_267495_.indexOf((Object)p_275397_)) != -1) {
            p_275386_.m_169146_(NarratedElementType.POSITION, Component.m_237110_("narrator.position.tab", $$2 + 1, this.f_267380_.size()));
        }
    }

    @Override
    public void m_88315_(GuiGraphics p_281720_, int p_282085_, int p_281687_, float p_283048_) {
        p_281720_.m_280509_(0, 0, this.f_267467_, 24, -16777216);
        p_281720_.m_280163_(CreateWorldScreen.f_273823_, 0, this.f_273942_.m_252907_() + this.f_273942_.m_93694_() - 2, 0.0f, 0.0f, this.f_267467_, 2, 32, 2);
        for (TabButton $$4 : this.f_267495_) {
            $$4.m_88315_(p_281720_, p_282085_, p_281687_, p_283048_);
        }
    }

    @Override
    public ScreenRectangle m_264198_() {
        return this.f_273942_.m_264198_();
    }

    public void m_267766_() {
        int $$0 = Math.min(400, this.f_267467_) - 28;
        int $$1 = Mth.m_144941_($$0 / this.f_267380_.size(), 2);
        for (TabButton $$2 : this.f_267495_) {
            $$2.m_93674_($$1);
        }
        this.f_273942_.m_264036_();
        this.f_273942_.m_252865_(Mth.m_144941_((this.f_267467_ - $$0) / 2, 2));
        this.f_273942_.m_253211_(0);
    }

    public void m_276089_(int p_276107_, boolean p_276125_) {
        if (this.m_93696_()) {
            this.m_7522_((GuiEventListener)this.f_267495_.get(p_276107_));
        } else {
            this.f_267401_.m_276088_((Tab)this.f_267380_.get(p_276107_), p_276125_);
        }
    }

    public boolean m_269419_(int p_270495_) {
        int $$1;
        if (Screen.m_96637_() && ($$1 = this.m_269123_(p_270495_)) != -1) {
            this.m_276089_(Mth.m_14045_($$1, 0, this.f_267380_.size() - 1), true);
            return true;
        }
        return false;
    }

    private int m_269123_(int p_270508_) {
        int $$1;
        if (p_270508_ >= 49 && p_270508_ <= 57) {
            return p_270508_ - 49;
        }
        if (p_270508_ == 258 && ($$1 = this.m_269025_()) != -1) {
            int $$2 = Screen.m_96638_() ? $$1 - 1 : $$1 + 1;
            return Math.floorMod($$2, this.f_267380_.size());
        }
        return -1;
    }

    private int m_269025_() {
        Tab $$0 = this.f_267401_.m_267695_();
        int $$1 = this.f_267380_.indexOf((Object)$$0);
        return $$1 != -1 ? $$1 : -1;
    }

    @Nullable
    private TabButton m_274517_() {
        int $$0 = this.m_269025_();
        return $$0 != -1 ? (TabButton)this.f_267495_.get($$0) : null;
    }

    public static class Builder {
        private final int f_267429_;
        private final TabManager f_267468_;
        private final List<Tab> f_267496_ = new ArrayList<Tab>();

        Builder(TabManager p_268334_, int p_267986_) {
            this.f_267468_ = p_268334_;
            this.f_267429_ = p_267986_;
        }

        public Builder m_267824_(Tab ... p_268144_) {
            Collections.addAll(this.f_267496_, p_268144_);
            return this;
        }

        public TabNavigationBar m_267625_() {
            return new TabNavigationBar(this.f_267429_, this.f_267468_, this.f_267496_);
        }
    }
}

