/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class VertexFormat {
    public static final int UNKNOWN_ELEMENT = -1;
    private final List<VertexFormatElement> elements;
    private final List<String> names;
    private final int vertexSize;
    private final int elementsMask;
    private final int[] offsetsByElement = new int[32];
    @Nullable
    private VertexBuffer immediateDrawVertexBuffer;

    VertexFormat(List<VertexFormatElement> p_350393_, List<String> p_350887_, IntList p_350817_, int p_350310_) {
        this.elements = p_350393_;
        this.names = p_350887_;
        this.vertexSize = p_350310_;
        this.elementsMask = p_350393_.stream().mapToInt(VertexFormatElement::mask).reduce(0, (p_350941_, p_350570_) -> p_350941_ | p_350570_);
        for (int $$4 = 0; $$4 < this.offsetsByElement.length; ++$$4) {
            VertexFormatElement $$5 = VertexFormatElement.byId($$4);
            int $$6 = $$5 != null ? p_350393_.indexOf($$5) : -1;
            this.offsetsByElement[$$4] = $$6 != -1 ? p_350817_.getInt($$6) : -1;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder $$0 = new StringBuilder("Vertex format (").append(this.vertexSize).append(" bytes):\n");
        for (int $$1 = 0; $$1 < this.elements.size(); ++$$1) {
            VertexFormatElement $$2 = this.elements.get($$1);
            $$0.append($$1).append(". ").append(this.names.get($$1)).append(": ").append($$2).append(" @ ").append(this.getOffset($$2)).append('\n');
        }
        return $$0.toString();
    }

    public int getVertexSize() {
        return this.vertexSize;
    }

    public List<VertexFormatElement> getElements() {
        return this.elements;
    }

    public List<String> getElementAttributeNames() {
        return this.names;
    }

    public int[] getOffsetsByElement() {
        return this.offsetsByElement;
    }

    public int getOffset(VertexFormatElement p_350713_) {
        return this.offsetsByElement[p_350713_.id()];
    }

    public boolean contains(VertexFormatElement p_351022_) {
        return (this.elementsMask & p_351022_.mask()) != 0;
    }

    public int getElementsMask() {
        return this.elementsMask;
    }

    public String getElementName(VertexFormatElement p_350904_) {
        int $$1 = this.elements.indexOf(p_350904_);
        if ($$1 == -1) {
            throw new IllegalArgumentException(String.valueOf(p_350904_) + " is not contained in format");
        }
        return this.names.get($$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object p_86026_) {
        if (this == p_86026_) {
            return true;
        }
        if (!(p_86026_ instanceof VertexFormat)) return false;
        VertexFormat $$1 = (VertexFormat)p_86026_;
        if (this.elementsMask != $$1.elementsMask) return false;
        if (this.vertexSize != $$1.vertexSize) return false;
        if (!this.names.equals($$1.names)) return false;
        if (!Arrays.equals(this.offsetsByElement, $$1.offsetsByElement)) return false;
        return true;
    }

    public int hashCode() {
        return this.elementsMask * 31 + Arrays.hashCode(this.offsetsByElement);
    }

    public void setupBufferState() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(this::_setupBufferState);
            return;
        }
        this._setupBufferState();
    }

    private void _setupBufferState() {
        int $$0 = this.getVertexSize();
        for (int $$1 = 0; $$1 < this.elements.size(); ++$$1) {
            GlStateManager._enableVertexAttribArray($$1);
            VertexFormatElement $$2 = this.elements.get($$1);
            $$2.setupBufferState($$1, this.getOffset($$2), $$0);
        }
    }

    public void clearBufferState() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(this::_clearBufferState);
            return;
        }
        this._clearBufferState();
    }

    private void _clearBufferState() {
        for (int $$0 = 0; $$0 < this.elements.size(); ++$$0) {
            GlStateManager._disableVertexAttribArray($$0);
        }
    }

    public VertexBuffer getImmediateDrawVertexBuffer() {
        VertexBuffer $$0 = this.immediateDrawVertexBuffer;
        if ($$0 == null) {
            this.immediateDrawVertexBuffer = $$0 = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
        }
        return $$0;
    }

    public static class Builder {
        private final ImmutableMap.Builder<String, VertexFormatElement> elements = ImmutableMap.builder();
        private final IntList offsets = new IntArrayList();
        private int offset;

        Builder() {
        }

        public Builder add(String p_350281_, VertexFormatElement p_350956_) {
            this.elements.put((Object)p_350281_, (Object)p_350956_);
            this.offsets.add(this.offset);
            this.offset += p_350956_.byteSize();
            return this;
        }

        public Builder padding(int p_351055_) {
            this.offset += p_351055_;
            return this;
        }

        public VertexFormat build() {
            ImmutableMap $$0 = this.elements.buildOrThrow();
            ImmutableList $$1 = $$0.values().asList();
            ImmutableList $$2 = $$0.keySet().asList();
            return new VertexFormat((List<VertexFormatElement>)$$1, (List<String>)$$2, this.offsets, this.offset);
        }
    }

    public static enum Mode {
        LINES(4, 2, 2, false),
        LINE_STRIP(5, 2, 1, true),
        DEBUG_LINES(1, 2, 2, false),
        DEBUG_LINE_STRIP(3, 2, 1, true),
        TRIANGLES(4, 3, 3, false),
        TRIANGLE_STRIP(5, 3, 1, true),
        TRIANGLE_FAN(6, 3, 1, true),
        QUADS(4, 4, 4, false);

        public final int asGLMode;
        public final int primitiveLength;
        public final int primitiveStride;
        public final boolean connectedPrimitives;

        private Mode(int p_231238_, int p_231239_, int p_231240_, boolean p_231241_) {
            this.asGLMode = p_231238_;
            this.primitiveLength = p_231239_;
            this.primitiveStride = p_231240_;
            this.connectedPrimitives = p_231241_;
        }

        public int indexCount(int p_166959_) {
            int $$3;
            switch (this.ordinal()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    int $$1 = p_166959_;
                    break;
                }
                case 0: 
                case 7: {
                    int $$2 = p_166959_ / 4 * 6;
                    break;
                }
                default: {
                    $$3 = 0;
                }
            }
            return $$3;
        }
    }

    public static enum IndexType {
        SHORT(5123, 2),
        INT(5125, 4);

        public final int asGLType;
        public final int bytes;

        private IndexType(int p_166930_, int p_166931_) {
            this.asGLType = p_166930_;
            this.bytes = p_166931_;
        }

        public static IndexType least(int p_166934_) {
            if ((p_166934_ & 0xFFFF0000) != 0) {
                return INT;
            }
            return SHORT;
        }
    }
}

