/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.math.LongMath;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2BooleanFunction;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class PeriodicNotificationManager
extends SimplePreparableReloadListener<Map<String, List<Notification>>>
implements AutoCloseable {
    private static final Codec<Map<String, List<Notification>>> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)RecordCodecBuilder.create(p_205303_ -> p_205303_.group((App)Codec.LONG.optionalFieldOf("delay", (Object)0L).forGetter(Notification::delay), (App)Codec.LONG.fieldOf("period").forGetter(Notification::period), (App)Codec.STRING.fieldOf("title").forGetter(Notification::title), (App)Codec.STRING.fieldOf("message").forGetter(Notification::message)).apply((Applicative)p_205303_, Notification::new)).listOf());
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ResourceLocation notifications;
    private final Object2BooleanFunction<String> selector;
    @Nullable
    private Timer timer;
    @Nullable
    private NotificationTask notificationTask;

    public PeriodicNotificationManager(ResourceLocation p_205293_, Object2BooleanFunction<String> p_205294_) {
        this.notifications = p_205293_;
        this.selector = p_205294_;
    }

    @Override
    protected Map<String, List<Notification>> prepare(ResourceManager p_205300_, ProfilerFiller p_205301_) {
        Map map;
        block8: {
            BufferedReader $$2 = p_205300_.openAsReader(this.notifications);
            try {
                map = (Map)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)$$2)).result().orElseThrow();
                if ($$2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if ($$2 != null) {
                        try {
                            ((Reader)$$2).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception $$3) {
                    LOGGER.warn("Failed to load {}", (Object)this.notifications, (Object)$$3);
                    return ImmutableMap.of();
                }
            }
            ((Reader)$$2).close();
        }
        return map;
    }

    @Override
    protected void apply(Map<String, List<Notification>> p_205318_, ResourceManager p_205319_, ProfilerFiller p_205320_) {
        List<Notification> $$3 = p_205318_.entrySet().stream().filter(p_205316_ -> (Boolean)this.selector.apply((Object)((String)p_205316_.getKey()))).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
        if ($$3.isEmpty()) {
            this.stopTimer();
            return;
        }
        if ($$3.stream().anyMatch(p_205326_ -> p_205326_.period == 0L)) {
            Util.logAndPauseIfInIde("A periodic notification in " + String.valueOf(this.notifications) + " has a period of zero minutes");
            this.stopTimer();
            return;
        }
        long $$4 = this.calculateInitialDelay($$3);
        long $$5 = this.calculateOptimalPeriod($$3, $$4);
        if (this.timer == null) {
            this.timer = new Timer();
        }
        this.notificationTask = this.notificationTask == null ? new NotificationTask($$3, $$4, $$5) : this.notificationTask.reset($$3, $$5);
        this.timer.scheduleAtFixedRate((TimerTask)this.notificationTask, TimeUnit.MINUTES.toMillis($$4), TimeUnit.MINUTES.toMillis($$5));
    }

    @Override
    public void close() {
        this.stopTimer();
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private long calculateOptimalPeriod(List<Notification> p_205313_, long p_205314_) {
        return p_205313_.stream().mapToLong(p_205298_ -> {
            long $$2 = p_205298_.delay - p_205314_;
            return LongMath.gcd((long)$$2, (long)p_205298_.period);
        }).reduce(LongMath::gcd).orElseThrow(() -> new IllegalStateException("Empty notifications from: " + String.valueOf(this.notifications)));
    }

    private long calculateInitialDelay(List<Notification> p_205311_) {
        return p_205311_.stream().mapToLong(p_205305_ -> p_205305_.delay).min().orElse(0L);
    }

    @Override
    protected /* synthetic */ Object prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        return this.prepare(resourceManager, profilerFiller);
    }

    static class NotificationTask
    extends TimerTask {
        private final Minecraft minecraft = Minecraft.getInstance();
        private final List<Notification> notifications;
        private final long period;
        private final AtomicLong elapsed;

        public NotificationTask(List<Notification> p_205350_, long p_205351_, long p_205352_) {
            this.notifications = p_205350_;
            this.period = p_205352_;
            this.elapsed = new AtomicLong(p_205351_);
        }

        public NotificationTask reset(List<Notification> p_205357_, long p_205358_) {
            this.cancel();
            return new NotificationTask(p_205357_, this.elapsed.get(), p_205358_);
        }

        @Override
        public void run() {
            long $$0 = this.elapsed.getAndAdd(this.period);
            long $$1 = this.elapsed.get();
            for (Notification $$2 : this.notifications) {
                long $$4;
                long $$3;
                if ($$0 < $$2.delay || ($$3 = $$0 / $$2.period) == ($$4 = $$1 / $$2.period)) continue;
                this.minecraft.execute(() -> SystemToast.add(Minecraft.getInstance().getToasts(), SystemToast.SystemToastId.PERIODIC_NOTIFICATION, Component.translatable(p_314393_.title, $$3), Component.translatable(p_314393_.message, $$3)));
                return;
            }
        }
    }

    public record Notification(long delay, long period, String title, String message) {
        public Notification(long delay, long period, String title, String message) {
            this.delay = delay != 0L ? delay : period;
            this.period = period;
            this.title = title;
            this.message = message;
        }
    }
}

