/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.slf4j.Logger;

public class Screenshot {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String SCREENSHOT_DIR = "screenshots";
    private int rowHeight;
    private final DataOutputStream outputStream;
    private final byte[] bytes;
    private final int width;
    private final int height;
    private File file;

    public static void grab(File p_92290_, RenderTarget p_92293_, Consumer<Component> p_92294_) {
        Screenshot.grab(p_92290_, null, p_92293_, p_92294_);
    }

    public static void grab(File p_92296_, @Nullable String p_92297_, RenderTarget p_92300_, Consumer<Component> p_92301_) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> Screenshot._grab(p_92296_, p_92297_, p_92300_, p_92301_));
        } else {
            Screenshot._grab(p_92296_, p_92297_, p_92300_, p_92301_);
        }
    }

    private static void _grab(File p_92306_, @Nullable String p_92307_, RenderTarget p_92310_, Consumer<Component> p_92311_) {
        File $$7;
        NativeImage $$4 = Screenshot.takeScreenshot(p_92310_);
        File $$5 = new File(p_92306_, SCREENSHOT_DIR);
        $$5.mkdir();
        if (p_92307_ == null) {
            File $$6 = Screenshot.getFile($$5);
        } else {
            $$7 = new File($$5, p_92307_);
        }
        Util.ioPool().execute(() -> {
            try {
                $$4.writeToFile($$7);
                MutableComponent $$3 = Component.literal($$7.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(p_168608_ -> p_168608_.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, $$7.getAbsolutePath())));
                p_92311_.accept(Component.translatable("screenshot.success", $$3));
            }
            catch (Exception $$4) {
                LOGGER.warn("Couldn't save screenshot", (Throwable)$$4);
                p_92311_.accept(Component.translatable("screenshot.failure", $$4.getMessage()));
            }
            finally {
                $$4.close();
            }
        });
    }

    public static NativeImage takeScreenshot(RenderTarget p_92282_) {
        int $$1 = p_92282_.width;
        int $$2 = p_92282_.height;
        NativeImage $$3 = new NativeImage($$1, $$2, false);
        RenderSystem.bindTexture(p_92282_.getColorTextureId());
        $$3.downloadTexture(0, true);
        $$3.flipY();
        return $$3;
    }

    private static File getFile(File p_92288_) {
        String $$1 = Util.getFilenameFormattedDateTime();
        int $$2 = 1;
        File $$3;
        while (($$3 = new File(p_92288_, $$1 + (String)($$2 == 1 ? "" : "_" + $$2) + ".png")).exists()) {
            ++$$2;
        }
        return $$3;
    }

    public Screenshot(File p_168601_, int p_168602_, int p_168603_, int p_168604_) throws IOException {
        this.width = p_168602_;
        this.height = p_168603_;
        this.rowHeight = p_168604_;
        File $$4 = new File(p_168601_, SCREENSHOT_DIR);
        $$4.mkdir();
        String $$5 = "huge_" + Util.getFilenameFormattedDateTime();
        int $$6 = 1;
        while ((this.file = new File($$4, $$5 + (String)($$6 == 1 ? "" : "_" + $$6) + ".tga")).exists()) {
            ++$$6;
        }
        byte[] $$7 = new byte[18];
        $$7[2] = 2;
        $$7[12] = (byte)(p_168602_ % 256);
        $$7[13] = (byte)(p_168602_ / 256);
        $$7[14] = (byte)(p_168603_ % 256);
        $$7[15] = (byte)(p_168603_ / 256);
        $$7[16] = 24;
        this.bytes = new byte[p_168602_ * p_168604_ * 3];
        this.outputStream = new DataOutputStream(new FileOutputStream(this.file));
        this.outputStream.write($$7);
    }

    public void addRegion(ByteBuffer p_168610_, int p_168611_, int p_168612_, int p_168613_, int p_168614_) {
        int $$5 = p_168613_;
        int $$6 = p_168614_;
        if ($$5 > this.width - p_168611_) {
            $$5 = this.width - p_168611_;
        }
        if ($$6 > this.height - p_168612_) {
            $$6 = this.height - p_168612_;
        }
        this.rowHeight = $$6;
        for (int $$7 = 0; $$7 < $$6; ++$$7) {
            p_168610_.position((p_168614_ - $$6) * p_168613_ * 3 + $$7 * p_168613_ * 3);
            int $$8 = (p_168611_ + $$7 * this.width) * 3;
            p_168610_.get(this.bytes, $$8, $$5 * 3);
        }
    }

    public void saveRow() throws IOException {
        this.outputStream.write(this.bytes, 0, this.width * 3 * this.rowHeight);
    }

    public File close() throws IOException {
        this.outputStream.close();
        return this.file;
    }
}

