/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.prediction.BlockStatePredictionHandler;
import net.minecraft.client.multiplayer.prediction.PredictiveAction;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.network.protocol.game.ServerboundContainerButtonClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerSlotStateChangedPacket;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemPacket;
import net.minecraft.network.protocol.game.ServerboundPlaceRecipePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class MultiPlayerGameMode {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Minecraft minecraft;
    private final ClientPacketListener connection;
    private BlockPos destroyBlockPos = new BlockPos(-1, -1, -1);
    private ItemStack destroyingItem = ItemStack.EMPTY;
    private float destroyProgress;
    private float destroyTicks;
    private int destroyDelay;
    private boolean isDestroying;
    private GameType localPlayerMode = GameType.DEFAULT_MODE;
    @Nullable
    private GameType previousLocalPlayerMode;
    private int carriedIndex;

    public MultiPlayerGameMode(Minecraft p_105203_, ClientPacketListener p_105204_) {
        this.minecraft = p_105203_;
        this.connection = p_105204_;
    }

    public void adjustPlayer(Player p_105222_) {
        this.localPlayerMode.updatePlayerAbilities(p_105222_.getAbilities());
    }

    public void setLocalMode(GameType p_171806_, @Nullable GameType p_171807_) {
        this.localPlayerMode = p_171806_;
        this.previousLocalPlayerMode = p_171807_;
        this.localPlayerMode.updatePlayerAbilities(this.minecraft.player.getAbilities());
    }

    public void setLocalMode(GameType p_105280_) {
        if (p_105280_ != this.localPlayerMode) {
            this.previousLocalPlayerMode = this.localPlayerMode;
        }
        this.localPlayerMode = p_105280_;
        this.localPlayerMode.updatePlayerAbilities(this.minecraft.player.getAbilities());
    }

    public boolean canHurtPlayer() {
        return this.localPlayerMode.isSurvival();
    }

    public boolean destroyBlock(BlockPos p_105268_) {
        if (this.minecraft.player.blockActionRestricted(this.minecraft.level, p_105268_, this.localPlayerMode)) {
            return false;
        }
        ClientLevel $$1 = this.minecraft.level;
        BlockState $$2 = $$1.getBlockState(p_105268_);
        if (!this.minecraft.player.getMainHandItem().getItem().canAttackBlock($$2, $$1, p_105268_, this.minecraft.player)) {
            return false;
        }
        Block $$3 = $$2.getBlock();
        if ($$3 instanceof GameMasterBlock && !this.minecraft.player.canUseGameMasterBlocks()) {
            return false;
        }
        if ($$2.isAir()) {
            return false;
        }
        $$3.playerWillDestroy($$1, p_105268_, $$2, this.minecraft.player);
        FluidState $$4 = $$1.getFluidState(p_105268_);
        boolean $$5 = $$1.setBlock(p_105268_, $$4.createLegacyBlock(), 11);
        if ($$5) {
            $$3.destroy($$1, p_105268_, $$2);
        }
        return $$5;
    }

    public boolean startDestroyBlock(BlockPos p_105270_, Direction p_105271_) {
        if (this.minecraft.player.blockActionRestricted(this.minecraft.level, p_105270_, this.localPlayerMode)) {
            return false;
        }
        if (!this.minecraft.level.getWorldBorder().isWithinBounds(p_105270_)) {
            return false;
        }
        if (this.localPlayerMode.isCreative()) {
            BlockState $$2 = this.minecraft.level.getBlockState(p_105270_);
            this.minecraft.getTutorial().onDestroyBlock(this.minecraft.level, p_105270_, $$2, 1.0f);
            this.startPrediction(this.minecraft.level, p_233757_ -> {
                this.destroyBlock(p_105270_);
                return new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, p_105270_, p_105271_, p_233757_);
            });
            this.destroyDelay = 5;
        } else if (!this.isDestroying || !this.sameDestroyTarget(p_105270_)) {
            if (this.isDestroying) {
                this.connection.send(new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, this.destroyBlockPos, p_105271_));
            }
            BlockState $$3 = this.minecraft.level.getBlockState(p_105270_);
            this.minecraft.getTutorial().onDestroyBlock(this.minecraft.level, p_105270_, $$3, 0.0f);
            this.startPrediction(this.minecraft.level, p_233728_ -> {
                boolean $$4;
                boolean bl = $$4 = !$$3.isAir();
                if ($$4 && this.destroyProgress == 0.0f) {
                    $$3.attack(this.minecraft.level, p_105270_, this.minecraft.player);
                }
                if ($$4 && $$3.getDestroyProgress(this.minecraft.player, this.minecraft.player.level(), p_105270_) >= 1.0f) {
                    this.destroyBlock(p_105270_);
                } else {
                    this.isDestroying = true;
                    this.destroyBlockPos = p_105270_;
                    this.destroyingItem = this.minecraft.player.getMainHandItem();
                    this.destroyProgress = 0.0f;
                    this.destroyTicks = 0.0f;
                    this.minecraft.level.destroyBlockProgress(this.minecraft.player.getId(), this.destroyBlockPos, this.getDestroyStage());
                }
                return new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, p_105270_, p_105271_, p_233728_);
            });
        }
        return true;
    }

    public void stopDestroyBlock() {
        if (this.isDestroying) {
            BlockState $$0 = this.minecraft.level.getBlockState(this.destroyBlockPos);
            this.minecraft.getTutorial().onDestroyBlock(this.minecraft.level, this.destroyBlockPos, $$0, -1.0f);
            this.connection.send(new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, this.destroyBlockPos, Direction.DOWN));
            this.isDestroying = false;
            this.destroyProgress = 0.0f;
            this.minecraft.level.destroyBlockProgress(this.minecraft.player.getId(), this.destroyBlockPos, -1);
            this.minecraft.player.resetAttackStrengthTicker();
        }
    }

    public boolean continueDestroyBlock(BlockPos p_105284_, Direction p_105285_) {
        this.ensureHasSentCarriedItem();
        if (this.destroyDelay > 0) {
            --this.destroyDelay;
            return true;
        }
        if (this.localPlayerMode.isCreative() && this.minecraft.level.getWorldBorder().isWithinBounds(p_105284_)) {
            this.destroyDelay = 5;
            BlockState $$2 = this.minecraft.level.getBlockState(p_105284_);
            this.minecraft.getTutorial().onDestroyBlock(this.minecraft.level, p_105284_, $$2, 1.0f);
            this.startPrediction(this.minecraft.level, p_233753_ -> {
                this.destroyBlock(p_105284_);
                return new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, p_105284_, p_105285_, p_233753_);
            });
            return true;
        }
        if (this.sameDestroyTarget(p_105284_)) {
            BlockState $$3 = this.minecraft.level.getBlockState(p_105284_);
            if ($$3.isAir()) {
                this.isDestroying = false;
                return false;
            }
            this.destroyProgress += $$3.getDestroyProgress(this.minecraft.player, this.minecraft.player.level(), p_105284_);
            if (this.destroyTicks % 4.0f == 0.0f) {
                SoundType $$4 = $$3.getSoundType();
                this.minecraft.getSoundManager().play(new SimpleSoundInstance($$4.getHitSound(), SoundSource.BLOCKS, ($$4.getVolume() + 1.0f) / 8.0f, $$4.getPitch() * 0.5f, SoundInstance.createUnseededRandom(), p_105284_));
            }
            this.destroyTicks += 1.0f;
            this.minecraft.getTutorial().onDestroyBlock(this.minecraft.level, p_105284_, $$3, Mth.clamp(this.destroyProgress, 0.0f, 1.0f));
            if (this.destroyProgress >= 1.0f) {
                this.isDestroying = false;
                this.startPrediction(this.minecraft.level, p_233739_ -> {
                    this.destroyBlock(p_105284_);
                    return new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, p_105284_, p_105285_, p_233739_);
                });
                this.destroyProgress = 0.0f;
                this.destroyTicks = 0.0f;
                this.destroyDelay = 5;
            }
        } else {
            return this.startDestroyBlock(p_105284_, p_105285_);
        }
        this.minecraft.level.destroyBlockProgress(this.minecraft.player.getId(), this.destroyBlockPos, this.getDestroyStage());
        return true;
    }

    private void startPrediction(ClientLevel p_233730_, PredictiveAction p_233731_) {
        try (BlockStatePredictionHandler $$2 = p_233730_.getBlockStatePredictionHandler().startPredicting();){
            int $$3 = $$2.currentSequence();
            Packet<ServerGamePacketListener> $$4 = p_233731_.predict($$3);
            this.connection.send($$4);
        }
    }

    public void tick() {
        this.ensureHasSentCarriedItem();
        if (this.connection.getConnection().isConnected()) {
            this.connection.getConnection().tick();
        } else {
            this.connection.getConnection().handleDisconnection();
        }
    }

    private boolean sameDestroyTarget(BlockPos p_105282_) {
        ItemStack $$1 = this.minecraft.player.getMainHandItem();
        return p_105282_.equals(this.destroyBlockPos) && ItemStack.isSameItemSameComponents($$1, this.destroyingItem);
    }

    private void ensureHasSentCarriedItem() {
        int $$0 = this.minecraft.player.getInventory().selected;
        if ($$0 != this.carriedIndex) {
            this.carriedIndex = $$0;
            this.connection.send(new ServerboundSetCarriedItemPacket(this.carriedIndex));
        }
    }

    public InteractionResult useItemOn(LocalPlayer p_233733_, InteractionHand p_233734_, BlockHitResult p_233735_) {
        this.ensureHasSentCarriedItem();
        if (!this.minecraft.level.getWorldBorder().isWithinBounds(p_233735_.getBlockPos())) {
            return InteractionResult.FAIL;
        }
        MutableObject $$3 = new MutableObject();
        this.startPrediction(this.minecraft.level, p_233745_ -> {
            $$3.setValue((Object)this.performUseItemOn(p_233733_, p_233734_, p_233735_));
            return new ServerboundUseItemOnPacket(p_233734_, p_233735_, p_233745_);
        });
        return (InteractionResult)((Object)$$3.getValue());
    }

    private InteractionResult performUseItemOn(LocalPlayer p_233747_, InteractionHand p_233748_, BlockHitResult p_233749_) {
        InteractionResult $$13;
        boolean $$6;
        BlockPos $$3 = p_233749_.getBlockPos();
        ItemStack $$4 = p_233747_.getItemInHand(p_233748_);
        if (this.localPlayerMode == GameType.SPECTATOR) {
            return InteractionResult.SUCCESS;
        }
        boolean $$5 = !p_233747_.getMainHandItem().isEmpty() || !p_233747_.getOffhandItem().isEmpty();
        boolean bl = $$6 = p_233747_.isSecondaryUseActive() && $$5;
        if (!$$6) {
            InteractionResult $$9;
            BlockState $$7 = this.minecraft.level.getBlockState($$3);
            if (!this.connection.isFeatureEnabled($$7.getBlock().requiredFeatures())) {
                return InteractionResult.FAIL;
            }
            ItemInteractionResult $$8 = $$7.useItemOn(p_233747_.getItemInHand(p_233748_), this.minecraft.level, p_233747_, p_233748_, p_233749_);
            if ($$8.consumesAction()) {
                return $$8.result();
            }
            if ($$8 == ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION && p_233748_ == InteractionHand.MAIN_HAND && ($$9 = $$7.useWithoutItem(this.minecraft.level, p_233747_, p_233749_)).consumesAction()) {
                return $$9;
            }
        }
        if ($$4.isEmpty() || p_233747_.getCooldowns().isOnCooldown($$4.getItem())) {
            return InteractionResult.PASS;
        }
        UseOnContext $$10 = new UseOnContext(p_233747_, p_233748_, p_233749_);
        if (this.localPlayerMode.isCreative()) {
            int $$11 = $$4.getCount();
            InteractionResult $$12 = $$4.useOn($$10);
            $$4.setCount($$11);
        } else {
            $$13 = $$4.useOn($$10);
        }
        return $$13;
    }

    public InteractionResult useItem(Player p_233722_, InteractionHand p_233723_) {
        if (this.localPlayerMode == GameType.SPECTATOR) {
            return InteractionResult.PASS;
        }
        this.ensureHasSentCarriedItem();
        MutableObject $$2 = new MutableObject();
        this.startPrediction(this.minecraft.level, p_233720_ -> {
            ServerboundUseItemPacket $$4 = new ServerboundUseItemPacket(p_233723_, p_233720_, p_233722_.getYRot(), p_233722_.getXRot());
            ItemStack $$5 = p_233722_.getItemInHand(p_233723_);
            if (p_233722_.getCooldowns().isOnCooldown($$5.getItem())) {
                $$2.setValue((Object)InteractionResult.PASS);
                return $$4;
            }
            InteractionResultHolder<ItemStack> $$6 = $$5.use(this.minecraft.level, p_233722_, p_233723_);
            ItemStack $$7 = $$6.getObject();
            if ($$7 != $$5) {
                p_233722_.setItemInHand(p_233723_, $$7);
            }
            $$2.setValue((Object)$$6.getResult());
            return $$4;
        });
        return (InteractionResult)((Object)$$2.getValue());
    }

    public LocalPlayer createPlayer(ClientLevel p_105247_, StatsCounter p_105248_, ClientRecipeBook p_105249_) {
        return this.createPlayer(p_105247_, p_105248_, p_105249_, false, false);
    }

    public LocalPlayer createPlayer(ClientLevel p_105251_, StatsCounter p_105252_, ClientRecipeBook p_105253_, boolean p_105254_, boolean p_105255_) {
        return new LocalPlayer(this.minecraft, p_105251_, this.connection, p_105252_, p_105253_, p_105254_, p_105255_);
    }

    public void attack(Player p_105224_, Entity p_105225_) {
        this.ensureHasSentCarriedItem();
        this.connection.send(ServerboundInteractPacket.createAttackPacket(p_105225_, p_105224_.isShiftKeyDown()));
        if (this.localPlayerMode != GameType.SPECTATOR) {
            p_105224_.attack(p_105225_);
            p_105224_.resetAttackStrengthTicker();
        }
    }

    public InteractionResult interact(Player p_105227_, Entity p_105228_, InteractionHand p_105229_) {
        this.ensureHasSentCarriedItem();
        this.connection.send(ServerboundInteractPacket.createInteractionPacket(p_105228_, p_105227_.isShiftKeyDown(), p_105229_));
        if (this.localPlayerMode == GameType.SPECTATOR) {
            return InteractionResult.PASS;
        }
        return p_105227_.interactOn(p_105228_, p_105229_);
    }

    public InteractionResult interactAt(Player p_105231_, Entity p_105232_, EntityHitResult p_105233_, InteractionHand p_105234_) {
        this.ensureHasSentCarriedItem();
        Vec3 $$4 = p_105233_.getLocation().subtract(p_105232_.getX(), p_105232_.getY(), p_105232_.getZ());
        this.connection.send(ServerboundInteractPacket.createInteractionPacket(p_105232_, p_105231_.isShiftKeyDown(), p_105234_, $$4));
        if (this.localPlayerMode == GameType.SPECTATOR) {
            return InteractionResult.PASS;
        }
        return p_105232_.interactAt(p_105231_, $$4, p_105234_);
    }

    public void handleInventoryMouseClick(int p_171800_, int p_171801_, int p_171802_, ClickType p_171803_, Player p_171804_) {
        AbstractContainerMenu $$5 = p_171804_.containerMenu;
        if (p_171800_ != $$5.containerId) {
            LOGGER.warn("Ignoring click in mismatching container. Click in {}, player has {}.", (Object)p_171800_, (Object)$$5.containerId);
            return;
        }
        NonNullList<Slot> $$6 = $$5.slots;
        int $$7 = $$6.size();
        ArrayList $$8 = Lists.newArrayListWithCapacity((int)$$7);
        for (Slot $$9 : $$6) {
            $$8.add($$9.getItem().copy());
        }
        $$5.clicked(p_171801_, p_171802_, p_171803_, p_171804_);
        Int2ObjectOpenHashMap $$10 = new Int2ObjectOpenHashMap();
        for (int $$11 = 0; $$11 < $$7; ++$$11) {
            ItemStack $$13;
            ItemStack $$12 = (ItemStack)$$8.get($$11);
            if (ItemStack.matches($$12, $$13 = $$6.get($$11).getItem())) continue;
            $$10.put($$11, (Object)$$13.copy());
        }
        this.connection.send(new ServerboundContainerClickPacket(p_171800_, $$5.getStateId(), p_171801_, p_171802_, p_171803_, $$5.getCarried().copy(), (Int2ObjectMap<ItemStack>)$$10));
    }

    public void handlePlaceRecipe(int p_105218_, RecipeHolder<?> p_301105_, boolean p_105220_) {
        this.connection.send(new ServerboundPlaceRecipePacket(p_105218_, p_301105_, p_105220_));
    }

    public void handleInventoryButtonClick(int p_105209_, int p_105210_) {
        this.connection.send(new ServerboundContainerButtonClickPacket(p_105209_, p_105210_));
    }

    public void handleCreativeModeItemAdd(ItemStack p_105242_, int p_105243_) {
        if (this.localPlayerMode.isCreative() && this.connection.isFeatureEnabled(p_105242_.getItem().requiredFeatures())) {
            this.connection.send(new ServerboundSetCreativeModeSlotPacket(p_105243_, p_105242_));
        }
    }

    public void handleCreativeModeItemDrop(ItemStack p_105240_) {
        if (this.localPlayerMode.isCreative() && !p_105240_.isEmpty() && this.connection.isFeatureEnabled(p_105240_.getItem().requiredFeatures())) {
            this.connection.send(new ServerboundSetCreativeModeSlotPacket(-1, p_105240_));
        }
    }

    public void releaseUsingItem(Player p_105278_) {
        this.ensureHasSentCarriedItem();
        this.connection.send(new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.RELEASE_USE_ITEM, BlockPos.ZERO, Direction.DOWN));
        p_105278_.releaseUsingItem();
    }

    public boolean hasExperience() {
        return this.localPlayerMode.isSurvival();
    }

    public boolean hasMissTime() {
        return !this.localPlayerMode.isCreative();
    }

    public boolean hasInfiniteItems() {
        return this.localPlayerMode.isCreative();
    }

    public boolean isServerControlledInventory() {
        return this.minecraft.player.isPassenger() && this.minecraft.player.getVehicle() instanceof HasCustomInventoryScreen;
    }

    public boolean isAlwaysFlying() {
        return this.localPlayerMode == GameType.SPECTATOR;
    }

    @Nullable
    public GameType getPreviousPlayerMode() {
        return this.previousLocalPlayerMode;
    }

    public GameType getPlayerMode() {
        return this.localPlayerMode;
    }

    public boolean isDestroying() {
        return this.isDestroying;
    }

    public int getDestroyStage() {
        return this.destroyProgress > 0.0f ? (int)(this.destroyProgress * 10.0f) : -1;
    }

    public void handlePickItem(int p_105207_) {
        this.connection.send(new ServerboundPickItemPacket(p_105207_));
    }

    public void handleSlotStateChanged(int p_307527_, int p_307194_, boolean p_307559_) {
        this.connection.send(new ServerboundContainerSlotStateChangedPacket(p_307527_, p_307194_, p_307559_));
    }
}

