/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;

public class ScreenEffectRenderer {
    private static final ResourceLocation UNDERWATER_LOCATION = ResourceLocation.withDefaultNamespace("textures/misc/underwater.png");

    public static void renderScreenEffect(Minecraft p_110719_, PoseStack p_110720_) {
        BlockState $$3;
        LocalPlayer $$2 = p_110719_.player;
        if (!$$2.noPhysics && ($$3 = ScreenEffectRenderer.getViewBlockingState($$2)) != null) {
            ScreenEffectRenderer.renderTex(p_110719_.getBlockRenderer().getBlockModelShaper().getParticleIcon($$3), p_110720_);
        }
        if (!p_110719_.player.isSpectator()) {
            if (p_110719_.player.isEyeInFluid(FluidTags.WATER)) {
                ScreenEffectRenderer.renderWater(p_110719_, p_110720_);
            }
            if (p_110719_.player.isOnFire()) {
                ScreenEffectRenderer.renderFire(p_110719_, p_110720_);
            }
        }
    }

    @Nullable
    private static BlockState getViewBlockingState(Player p_110717_) {
        BlockPos.MutableBlockPos $$1 = new BlockPos.MutableBlockPos();
        for (int $$2 = 0; $$2 < 8; ++$$2) {
            double $$3 = p_110717_.getX() + (double)(((float)(($$2 >> 0) % 2) - 0.5f) * p_110717_.getBbWidth() * 0.8f);
            double $$4 = p_110717_.getEyeY() + (double)(((float)(($$2 >> 1) % 2) - 0.5f) * 0.1f * p_110717_.getScale());
            double $$5 = p_110717_.getZ() + (double)(((float)(($$2 >> 2) % 2) - 0.5f) * p_110717_.getBbWidth() * 0.8f);
            $$1.set($$3, $$4, $$5);
            BlockState $$6 = p_110717_.level().getBlockState($$1);
            if ($$6.getRenderShape() == RenderShape.INVISIBLE || !$$6.isViewBlocking(p_110717_.level(), $$1)) continue;
            return $$6;
        }
        return null;
    }

    private static void renderTex(TextureAtlasSprite p_173297_, PoseStack p_173298_) {
        RenderSystem.setShaderTexture(0, p_173297_.atlasLocation());
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        float $$2 = 0.1f;
        float $$3 = -1.0f;
        float $$4 = 1.0f;
        float $$5 = -1.0f;
        float $$6 = 1.0f;
        float $$7 = -0.5f;
        float $$8 = p_173297_.getU0();
        float $$9 = p_173297_.getU1();
        float $$10 = p_173297_.getV0();
        float $$11 = p_173297_.getV1();
        Matrix4f $$12 = p_173298_.last().pose();
        BufferBuilder $$13 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        $$13.addVertex($$12, -1.0f, -1.0f, -0.5f).setUv($$9, $$11).setColor(0.1f, 0.1f, 0.1f, 1.0f);
        $$13.addVertex($$12, 1.0f, -1.0f, -0.5f).setUv($$8, $$11).setColor(0.1f, 0.1f, 0.1f, 1.0f);
        $$13.addVertex($$12, 1.0f, 1.0f, -0.5f).setUv($$8, $$10).setColor(0.1f, 0.1f, 0.1f, 1.0f);
        $$13.addVertex($$12, -1.0f, 1.0f, -0.5f).setUv($$9, $$10).setColor(0.1f, 0.1f, 0.1f, 1.0f);
        BufferUploader.drawWithShader($$13.buildOrThrow());
    }

    private static void renderWater(Minecraft p_110726_, PoseStack p_110727_) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture(0, UNDERWATER_LOCATION);
        BlockPos $$2 = BlockPos.containing(p_110726_.player.getX(), p_110726_.player.getEyeY(), p_110726_.player.getZ());
        float $$3 = LightTexture.getBrightness(p_110726_.player.level().dimensionType(), p_110726_.player.level().getMaxLocalRawBrightness($$2));
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor($$3, $$3, $$3, 0.1f);
        float $$4 = 4.0f;
        float $$5 = -1.0f;
        float $$6 = 1.0f;
        float $$7 = -1.0f;
        float $$8 = 1.0f;
        float $$9 = -0.5f;
        float $$10 = -p_110726_.player.getYRot() / 64.0f;
        float $$11 = p_110726_.player.getXRot() / 64.0f;
        Matrix4f $$12 = p_110727_.last().pose();
        BufferBuilder $$13 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        $$13.addVertex($$12, -1.0f, -1.0f, -0.5f).setUv(4.0f + $$10, 4.0f + $$11);
        $$13.addVertex($$12, 1.0f, -1.0f, -0.5f).setUv(0.0f + $$10, 4.0f + $$11);
        $$13.addVertex($$12, 1.0f, 1.0f, -0.5f).setUv(0.0f + $$10, 0.0f + $$11);
        $$13.addVertex($$12, -1.0f, 1.0f, -0.5f).setUv(4.0f + $$10, 0.0f + $$11);
        BufferUploader.drawWithShader($$13.buildOrThrow());
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
    }

    private static void renderFire(Minecraft p_110729_, PoseStack p_110730_) {
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.depthFunc(519);
        RenderSystem.depthMask(false);
        RenderSystem.enableBlend();
        TextureAtlasSprite $$2 = ModelBakery.FIRE_1.sprite();
        RenderSystem.setShaderTexture(0, $$2.atlasLocation());
        float $$3 = $$2.getU0();
        float $$4 = $$2.getU1();
        float $$5 = ($$3 + $$4) / 2.0f;
        float $$6 = $$2.getV0();
        float $$7 = $$2.getV1();
        float $$8 = ($$6 + $$7) / 2.0f;
        float $$9 = $$2.uvShrinkRatio();
        float $$10 = Mth.lerp($$9, $$3, $$5);
        float $$11 = Mth.lerp($$9, $$4, $$5);
        float $$12 = Mth.lerp($$9, $$6, $$8);
        float $$13 = Mth.lerp($$9, $$7, $$8);
        float $$14 = 1.0f;
        for (int $$15 = 0; $$15 < 2; ++$$15) {
            p_110730_.pushPose();
            float $$16 = -0.5f;
            float $$17 = 0.5f;
            float $$18 = -0.5f;
            float $$19 = 0.5f;
            float $$20 = -0.5f;
            p_110730_.translate((float)(-($$15 * 2 - 1)) * 0.24f, -0.3f, 0.0f);
            p_110730_.mulPose(Axis.YP.rotationDegrees((float)($$15 * 2 - 1) * 10.0f));
            Matrix4f $$21 = p_110730_.last().pose();
            BufferBuilder $$22 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            $$22.addVertex($$21, -0.5f, -0.5f, -0.5f).setUv($$11, $$13).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            $$22.addVertex($$21, 0.5f, -0.5f, -0.5f).setUv($$10, $$13).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            $$22.addVertex($$21, 0.5f, 0.5f, -0.5f).setUv($$10, $$12).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            $$22.addVertex($$21, -0.5f, 0.5f, -0.5f).setUv($$11, $$12).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            BufferUploader.drawWithShader($$22.buildOrThrow());
            p_110730_.popPose();
        }
        RenderSystem.disableBlend();
        RenderSystem.depthMask(true);
        RenderSystem.depthFunc(515);
    }
}

