/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.block.model.multipart.MultiPart;
import net.minecraft.client.renderer.block.model.multipart.Selector;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;

public class BlockModelDefinition {
    private final Map<String, MultiVariant> variants = Maps.newLinkedHashMap();
    private MultiPart multiPart;

    public static BlockModelDefinition fromStream(Context p_111541_, Reader p_111542_) {
        return GsonHelper.fromJson(p_111541_.gson, p_111542_, BlockModelDefinition.class);
    }

    public static BlockModelDefinition fromJsonElement(Context p_249700_, JsonElement p_250730_) {
        return (BlockModelDefinition)p_249700_.gson.fromJson(p_250730_, BlockModelDefinition.class);
    }

    public BlockModelDefinition(Map<String, MultiVariant> p_111537_, MultiPart p_111538_) {
        this.multiPart = p_111538_;
        this.variants.putAll(p_111537_);
    }

    public BlockModelDefinition(List<BlockModelDefinition> p_111535_) {
        BlockModelDefinition $$1 = null;
        for (BlockModelDefinition $$2 : p_111535_) {
            if ($$2.isMultiPart()) {
                this.variants.clear();
                $$1 = $$2;
            }
            this.variants.putAll($$2.variants);
        }
        if ($$1 != null) {
            this.multiPart = $$1.multiPart;
        }
    }

    @VisibleForTesting
    public boolean hasVariant(String p_173426_) {
        return this.variants.get(p_173426_) != null;
    }

    @VisibleForTesting
    public MultiVariant getVariant(String p_173429_) {
        MultiVariant $$1 = this.variants.get(p_173429_);
        if ($$1 == null) {
            throw new MissingVariantException();
        }
        return $$1;
    }

    public boolean equals(Object p_111546_) {
        if (this == p_111546_) {
            return true;
        }
        if (p_111546_ instanceof BlockModelDefinition) {
            BlockModelDefinition $$1 = (BlockModelDefinition)p_111546_;
            if (this.variants.equals($$1.variants)) {
                return this.isMultiPart() ? this.multiPart.equals($$1.multiPart) : !$$1.isMultiPart();
            }
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.variants.hashCode() + (this.isMultiPart() ? this.multiPart.hashCode() : 0);
    }

    public Map<String, MultiVariant> getVariants() {
        return this.variants;
    }

    @VisibleForTesting
    public Set<MultiVariant> getMultiVariants() {
        HashSet $$0 = Sets.newHashSet(this.variants.values());
        if (this.isMultiPart()) {
            $$0.addAll(this.multiPart.getMultiVariants());
        }
        return $$0;
    }

    public boolean isMultiPart() {
        return this.multiPart != null;
    }

    public MultiPart getMultiPart() {
        return this.multiPart;
    }

    public static final class Context {
        protected final Gson gson = new GsonBuilder().registerTypeAdapter(BlockModelDefinition.class, (Object)new Deserializer()).registerTypeAdapter(Variant.class, (Object)new Variant.Deserializer()).registerTypeAdapter(MultiVariant.class, (Object)new MultiVariant.Deserializer()).registerTypeAdapter(MultiPart.class, (Object)new MultiPart.Deserializer(this)).registerTypeAdapter(Selector.class, (Object)new Selector.Deserializer()).create();
        private StateDefinition<Block, BlockState> definition;

        public StateDefinition<Block, BlockState> getDefinition() {
            return this.definition;
        }

        public void setDefinition(StateDefinition<Block, BlockState> p_111553_) {
            this.definition = p_111553_;
        }
    }

    protected class MissingVariantException
    extends RuntimeException {
        protected MissingVariantException() {
        }
    }

    public static class Deserializer
    implements JsonDeserializer<BlockModelDefinition> {
        public BlockModelDefinition deserialize(JsonElement p_111559_, Type p_111560_, JsonDeserializationContext p_111561_) throws JsonParseException {
            JsonObject $$3 = p_111559_.getAsJsonObject();
            Map<String, MultiVariant> $$4 = this.getVariants(p_111561_, $$3);
            MultiPart $$5 = this.getMultiPart(p_111561_, $$3);
            if ($$4.isEmpty() && ($$5 == null || $$5.getMultiVariants().isEmpty())) {
                throw new JsonParseException("Neither 'variants' nor 'multipart' found");
            }
            return new BlockModelDefinition($$4, $$5);
        }

        protected Map<String, MultiVariant> getVariants(JsonDeserializationContext p_111556_, JsonObject p_111557_) {
            HashMap $$2 = Maps.newHashMap();
            if (p_111557_.has("variants")) {
                JsonObject $$3 = GsonHelper.getAsJsonObject(p_111557_, "variants");
                for (Map.Entry $$4 : $$3.entrySet()) {
                    $$2.put((String)$$4.getKey(), (MultiVariant)p_111556_.deserialize((JsonElement)$$4.getValue(), MultiVariant.class));
                }
            }
            return $$2;
        }

        @Nullable
        protected MultiPart getMultiPart(JsonDeserializationContext p_111563_, JsonObject p_111564_) {
            if (!p_111564_.has("multipart")) {
                return null;
            }
            JsonArray $$2 = GsonHelper.getAsJsonArray(p_111564_, "multipart");
            return (MultiPart)p_111563_.deserialize((JsonElement)$$2, MultiPart.class);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

