/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture.atlas;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.Mth;
import org.slf4j.Logger;

@FunctionalInterface
public interface SpriteResourceLoader {
    public static final Logger LOGGER = LogUtils.getLogger();

    public static SpriteResourceLoader create(Collection<MetadataSectionSerializer<?>> p_296204_) {
        return (p_293680_, p_293681_) -> {
            void $$10;
            void $$5;
            try {
                ResourceMetadata $$3 = p_293681_.metadata().copySections(p_296204_);
            }
            catch (Exception $$4) {
                LOGGER.error("Unable to parse metadata from {}", (Object)p_293680_, (Object)$$4);
                return null;
            }
            try (InputStream $$6 = p_293681_.open();){
                NativeImage $$7 = NativeImage.read($$6);
            }
            catch (IOException $$9) {
                LOGGER.error("Using missing texture, unable to load {}", (Object)p_293680_, (Object)$$9);
                return null;
            }
            AnimationMetadataSection $$11 = $$5.getSection(AnimationMetadataSection.SERIALIZER).orElse(AnimationMetadataSection.EMPTY);
            FrameSize $$12 = $$11.calculateFrameSize($$10.getWidth(), $$10.getHeight());
            if (Mth.isMultipleOf($$10.getWidth(), $$12.width()) && Mth.isMultipleOf($$10.getHeight(), $$12.height())) {
                return new SpriteContents(p_293680_, $$12, (NativeImage)$$10, (ResourceMetadata)$$5);
            }
            LOGGER.error("Image {} size {},{} is not multiple of frame size {},{}", new Object[]{p_293680_, $$10.getWidth(), $$10.getHeight(), $$12.width(), $$12.height()});
            $$10.close();
            return null;
        };
    }

    @Nullable
    public SpriteContents loadSprite(ResourceLocation var1, Resource var2);
}

