/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.accesstransformer;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import net.neoforged.accesstransformer.AccessTransformer;
import net.neoforged.accesstransformer.TargetType;
import net.neoforged.accesstransformer.api.AccessTransformerEngine;
import net.neoforged.accesstransformer.parser.AccessTransformerList;
import org.antlr.v4.runtime.CharStream;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class AccessTransformerEngineImpl
implements AccessTransformerEngine {
    private final AccessTransformerList masterList = new AccessTransformerList();

    @Override
    public boolean transform(ClassNode clazzNode, Type classType) {
        if (!this.masterList.containsClassTarget(classType)) {
            return false;
        }
        HashSet privateChanged = new HashSet();
        Map<TargetType, Map<String, AccessTransformer>> transformersForTarget = this.masterList.getTransformersForTarget(classType);
        if (transformersForTarget.containsKey((Object)TargetType.CLASS)) {
            transformersForTarget.get((Object)TargetType.CLASS).forEach((n, at) -> at.applyModifier(clazzNode, ClassNode.class, privateChanged));
        }
        if (transformersForTarget.containsKey((Object)TargetType.FIELD)) {
            Map<String, AccessTransformer> fieldTransformers = transformersForTarget.get((Object)TargetType.FIELD);
            clazzNode.fields.stream().filter(fn -> fieldTransformers.containsKey(fn.name)).forEach(fn -> ((AccessTransformer)fieldTransformers.get(fn.name)).applyModifier(fn, FieldNode.class, privateChanged));
        }
        if (transformersForTarget.containsKey((Object)TargetType.METHOD)) {
            Map<String, AccessTransformer> methodTransformers = transformersForTarget.get((Object)TargetType.METHOD);
            clazzNode.methods.stream().filter(mn -> methodTransformers.containsKey(mn.name + mn.desc)).forEach(mn -> ((AccessTransformer)methodTransformers.get(mn.name + mn.desc)).applyModifier(mn, MethodNode.class, privateChanged));
        }
        if (!privateChanged.isEmpty()) {
            clazzNode.methods.forEach(mn -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(mn.instructions.iterator(), 16), false).filter(i -> i.getOpcode() == 183).map(MethodInsnNode.class::cast).filter(m -> privateChanged.contains(m.name + m.desc)).forEach(m -> m.setOpcode(182)));
        }
        return true;
    }

    @Override
    public void loadAT(CharStream charStream) {
        this.masterList.loadAT(charStream);
    }

    @Override
    public void loadATFromPath(Path path) throws IOException {
        this.masterList.loadFromPath(path);
    }

    @Override
    public void loadATFromResource(String resourceName) throws URISyntaxException, IOException {
        this.masterList.loadFromResource(resourceName);
    }

    @Override
    public Set<Type> getTargets() {
        return this.masterList.getTargets();
    }
}

