/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import cpw.mods.modlauncher.api.ITransformer;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.List;
import net.neoforged.coremod.CoreModScriptingEngine;
import net.neoforged.coremod.ICoreModScriptSource;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.moddiscovery.CoreModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CoreModScriptLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreModScriptLoader.class);

    private CoreModScriptLoader() {
    }

    public static List<ITransformer<?>> loadCoreModScripts(List<ModFileInfo> modFileInfos) {
        CoreModScriptingEngine engine;
        try {
            engine = new CoreModScriptingEngine();
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalStateException("Could not find the coremod script-engine, but the following mods require it: " + String.valueOf(modFileInfos), e);
        }
        LOGGER.debug(LogMarkers.CORE, "Loading coremod scripts");
        for (ModFileInfo modFile : modFileInfos) {
            for (CoreModFile coreMod : modFile.getFile().getCoreMods()) {
                engine.loadCoreMod((ICoreModScriptSource)new ScriptSourceAdapter(coreMod));
            }
        }
        return engine.initializeCoreMods();
    }

    private record ScriptSourceAdapter(CoreModFile coreMod) implements ICoreModScriptSource
    {
        public Reader readCoreMod() throws IOException {
            return Files.newBufferedReader(this.coreMod.path());
        }

        public String getDebugSource() {
            return this.coreMod.path().toString();
        }

        public Reader getAdditionalFile(String fileName) throws IOException {
            return Files.newBufferedReader(this.coreMod.file().findResource(fileName));
        }

        public String getOwnerId() {
            return this.coreMod.file().getModInfos().getFirst().getModId();
        }

        @Override
        public String toString() {
            return "{Name: " + this.coreMod.name() + ", Owner: " + this.getOwnerId() + " @ " + this.getDebugSource() + "}";
        }
    }
}

