/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.targets;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.fml.loading.VersionInfo;
import net.neoforged.fml.loading.moddiscovery.locators.NeoForgeDevProvider;
import net.neoforged.fml.loading.moddiscovery.locators.UserdevLocator;
import net.neoforged.fml.loading.targets.ArgumentList;
import net.neoforged.fml.loading.targets.CommonLaunchHandler;
import net.neoforged.fml.util.DevEnvUtils;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonDevLaunchHandler
extends CommonLaunchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CommonDevLaunchHandler.class);
    private static final String MINECRAFT_CLASS_PATH = "net/minecraft/server/MinecraftServer.class";

    @Override
    public boolean isProduction() {
        return false;
    }

    @Override
    public void collectAdditionalModFileLocators(VersionInfo versionInfo, Consumer<IModFileCandidateLocator> output) {
        super.collectAdditionalModFileLocators(versionInfo, output);
        NeoForgeDevProvider neoForgeProvider = null;
        Map<String, List<Path>> groupedModFolders = CommonDevLaunchHandler.getGroupedModFolders();
        List<Path> minecraftFolders = groupedModFolders.get("minecraft");
        if (minecraftFolders != null) {
            for (Path candidateFolder : minecraftFolders) {
                if (!Files.isRegularFile(candidateFolder.resolve(MINECRAFT_CLASS_PATH), new LinkOption[0])) continue;
                LOG.debug("Launching with NeoForge from {}", minecraftFolders);
                neoForgeProvider = new NeoForgeDevProvider(minecraftFolders);
                break;
            }
        }
        if (neoForgeProvider == null) {
            Path classesRoot = DevEnvUtils.findFileSystemRootOfFileOnClasspath(MINECRAFT_CLASS_PATH);
            LOG.debug("Launching with NeoForge from {}", (Object)classesRoot);
            neoForgeProvider = new NeoForgeDevProvider(List.of(classesRoot));
        }
        output.accept(neoForgeProvider);
        output.accept(new UserdevLocator(groupedModFolders));
    }

    @Override
    protected String[] preLaunch(String[] arguments, ModuleLayer layer) {
        super.preLaunch(arguments, layer);
        if (this.getDist().isDedicatedServer()) {
            return arguments;
        }
        if (this.isData()) {
            return arguments;
        }
        ArgumentList args = ArgumentList.from(arguments);
        String username = args.get("username");
        if (username != null) {
            Matcher m = Pattern.compile("#+").matcher(username);
            StringBuilder replaced = new StringBuilder();
            while (m.find()) {
                m.appendReplacement(replaced, CommonDevLaunchHandler.getRandomNumbers(m.group().length()));
            }
            m.appendTail(replaced);
            args.put("username", replaced.toString());
        } else {
            args.putLazy("username", "Dev");
        }
        if (!args.hasValue("accessToken")) {
            args.put("accessToken", "0");
        }
        return args.getArguments();
    }

    private static String getRandomNumbers(int length) {
        return Long.toString(System.nanoTime() % (long)((int)Math.pow(10.0, length)));
    }
}

