/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.blockentities.TrackMineBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TrackMineBlock
extends RailBlock
implements IExplosive,
EntityBlock {
    public TrackMineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_150930_((Item)SCContent.MINE_REMOTE_ACCESS_TOOL.get())) {
            return InteractionResult.SUCCESS;
        }
        if (this.isActive(level, pos) && this.isDefusable() && player.m_21120_(hand).m_41720_() == SCContent.WIRE_CUTTERS.get() && this.defuseMine(level, pos)) {
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            level.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (!this.isActive(level, pos) && heldItem.m_150930_(Items.f_42409_) && this.activateMine(level, pos)) {
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            level.m_5594_(null, pos, SoundEvents.f_12524_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.m_5880_(x$0, x$1, x$2, x$3), state, player, level, pos);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return (Boolean)ConfigHandler.SERVER.alwaysDrop.get() != false || super.canHarvestBlock(state, level, pos, player);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
    }

    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        TrackMineBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TrackMineBlockEntity && (be = (TrackMineBlockEntity)blockEntity).isActive()) {
            level.m_46961_(pos, false);
            level.m_255391_((Entity)cart, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 3.0f : 6.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionInteraction());
            cart.m_6074_();
        }
    }

    @Override
    public void explode(Level level, BlockPos pos) {
        TrackMineBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TrackMineBlockEntity && (be = (TrackMineBlockEntity)blockEntity).isActive()) {
            level.m_46961_(pos, false);
            level.m_255391_(null, (double)pos.m_123341_(), (double)pos.m_7494_().m_123342_(), (double)pos.m_123343_(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 3.0f : 6.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionInteraction());
        }
    }

    @Override
    public boolean activateMine(Level level, BlockPos pos) {
        TrackMineBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TrackMineBlockEntity && !(be = (TrackMineBlockEntity)blockEntity).isActive()) {
            be.activate();
            level.m_142346_(null, GameEvent.f_157792_, pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean defuseMine(Level level, BlockPos pos) {
        TrackMineBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TrackMineBlockEntity && (be = (TrackMineBlockEntity)blockEntity).isActive()) {
            be.deactivate();
            level.m_142346_(null, GameEvent.f_157792_, pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean isActive(Level level, BlockPos pos) {
        TrackMineBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        return blockEntity instanceof TrackMineBlockEntity && (be = (TrackMineBlockEntity)blockEntity).isActive();
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TrackMineBlockEntity(pos, state);
    }
}

