/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.recipe;

import java.util.function.Predicate;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.items.MineRemoteAccessToolItem;
import net.geforcemods.securitycraft.items.SentryRemoteAccessToolItem;
import net.geforcemods.securitycraft.items.SonicSecuritySystemItem;
import net.geforcemods.securitycraft.recipe.CombineRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class CopyPositionComponentItemRecipe
extends CombineRecipe {
    private final Item item;
    private final Predicate<CompoundTag> isDataEmpty;
    private final RecipeSerializer<? extends CustomRecipe> serializer;

    public CopyPositionComponentItemRecipe(ResourceLocation id, CraftingBookCategory craftingBookCategory, Item item, Predicate<CompoundTag> hasData, RecipeSerializer<? extends CustomRecipe> serializer) {
        super(id, craftingBookCategory);
        this.item = item;
        this.isDataEmpty = Predicate.not(hasData);
        this.serializer = serializer;
    }

    public static CopyPositionComponentItemRecipe cameraMonitor(ResourceLocation id, CraftingBookCategory craftingBookCategory) {
        return new CopyPositionComponentItemRecipe(id, craftingBookCategory, (Item)SCContent.CAMERA_MONITOR.get(), CameraMonitorItem::hasCameraAdded, (RecipeSerializer<? extends CustomRecipe>)((RecipeSerializer)SCContent.COPY_CAMERA_MONITOR_RECIPE_SERIALIZER.get()));
    }

    public static CopyPositionComponentItemRecipe mineRemoteAccessTool(ResourceLocation id, CraftingBookCategory craftingBookCategory) {
        return new CopyPositionComponentItemRecipe(id, craftingBookCategory, (Item)SCContent.MINE_REMOTE_ACCESS_TOOL.get(), MineRemoteAccessToolItem::hasMineAdded, (RecipeSerializer<? extends CustomRecipe>)((RecipeSerializer)SCContent.COPY_MINE_REMOTE_ACCESS_TOOL_RECIPE_SERIALIZER.get()));
    }

    public static CopyPositionComponentItemRecipe sentryRemoteAccessTool(ResourceLocation id, CraftingBookCategory craftingBookCategory) {
        return new CopyPositionComponentItemRecipe(id, craftingBookCategory, (Item)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get(), SentryRemoteAccessToolItem::hasSentryAdded, (RecipeSerializer<? extends CustomRecipe>)((RecipeSerializer)SCContent.COPY_SENTRY_REMOTE_ACCESS_TOOL_RECIPE_SERIALIZER.get()));
    }

    public static CopyPositionComponentItemRecipe sonicSecuritySystem(ResourceLocation id, CraftingBookCategory craftingBookCategory) {
        return new CopyPositionComponentItemRecipe(id, craftingBookCategory, (Item)SCContent.SONIC_SECURITY_SYSTEM_ITEM.get(), SonicSecuritySystemItem::hasLinkedBlock, (RecipeSerializer<? extends CustomRecipe>)((RecipeSerializer)SCContent.COPY_SONIC_SECURITY_SYSTEM_RECIPE_SERIALIZER.get()));
    }

    @Override
    public boolean matchesFirstItem(ItemStack stack) {
        return stack.m_150930_(this.item) && !this.isDataEmpty.test(stack.m_41784_());
    }

    @Override
    public boolean matchesSecondItem(ItemStack stack) {
        return stack.m_150930_(this.item) && this.isDataEmpty.test(stack.m_41784_());
    }

    @Override
    public ItemStack combine(ItemStack itemWithPositions, ItemStack emptyItem) {
        ItemStack result = new ItemStack((ItemLike)this.item, 2);
        result.m_41784_().m_128391_(itemWithPositions.m_41784_());
        return result;
    }

    public RecipeSerializer<? extends CustomRecipe> m_7707_() {
        return this.serializer;
    }
}

