/*
 * Decompiled with CFR 0.152.
 */
package ballistix.api.blast;

import ballistix.prefab.utils.BallistixCodecUtils;
import com.google.common.base.Objects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.ChunkPos;

public class AntigravedChunk {
    public static final Codec<AntigravedChunk> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BallistixCodecUtils.CHUNK_POS.fieldOf("pos").forGetter(AntigravedChunk::getPos), (App)Codec.INT.fieldOf("time").forGetter(AntigravedChunk::getTime)).apply((Applicative)instance, AntigravedChunk::new));
    private final ChunkPos pos;
    private int time = 0;

    public AntigravedChunk(ChunkPos pos, int time) {
        this.pos = pos;
        this.time = time;
    }

    public ChunkPos getPos() {
        return this.pos;
    }

    public int getTime() {
        return this.time;
    }

    public void decrementTime() {
        --this.time;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AntigravedChunk) {
            AntigravedChunk other = (AntigravedChunk)obj;
            return other.pos.equals((Object)this.pos) && other.time == this.time;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pos});
    }
}

