/*
 * Decompiled with CFR 0.152.
 */
package ballistix.api.blast;

import ballistix.api.blast.IBlast;
import ballistix.common.blast.util.Blast;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.IModBusEvent;

public class RegisterBlastEvent
extends Event
implements IModBusEvent {
    private final HashMap<ResourceLocation, IBlast> registeredBlasts = new HashMap();
    private final HashMap<IBlast, Item> registeredMinecarts = new HashMap();
    private final HashMap<IBlast, Item> registeredGrenades = new HashMap();
    private final List<Runnable> threadsToCache = new ArrayList<Runnable>();

    public void registerBlast(IBlast blast) {
        this.registeredBlasts.put(blast.id(), blast);
    }

    public void registerGrenade(IBlast blast, Item item) {
        this.registeredGrenades.put(blast, item);
    }

    public void registerMinecart(IBlast blast, Item item) {
        this.registeredMinecarts.put(blast, item);
    }

    public void submitCachedThreads(Runnable threadsSupplier) {
        this.threadsToCache.add(threadsSupplier);
    }

    public void stashBlasts() {
        Blast.BLAST_MAP.clear();
        Blast.BLAST_MAP.putAll(this.registeredBlasts);
        Blast.ITEM_TO_BLAST_MAP.clear();
        for (Map.Entry<ResourceLocation, IBlast> entry : this.registeredBlasts.entrySet()) {
            Blast.ITEM_TO_BLAST_MAP.put(entry.getValue().getExplosiveItem().get(), entry.getValue());
        }
        Blast.BLAST_TO_GRENADE_MAP.clear();
        Blast.BLAST_TO_GRENADE_MAP.putAll(this.registeredGrenades);
        Blast.BLAST_TO_MINECART_MAP.clear();
        Blast.BLAST_TO_MINECART_MAP.putAll(this.registeredMinecarts);
        for (Runnable runnable : this.threadsToCache) {
            runnable.run();
        }
    }
}

