/*
 * Decompiled with CFR 0.152.
 */
package ballistix.api.missile.virtual;

import ballistix.api.missile.MissileManager;
import ballistix.api.missile.virtual.VirtualMissile;
import ballistix.api.silo.ILauncherPlatform;
import ballistix.api.silo.ILauncherSupportFrame;
import ballistix.client.particle.ParticleOptionsMissileSmoke;
import ballistix.common.entity.EntityBullet;
import ballistix.common.entity.EntityRailgunRound;
import ballistix.common.entity.EntitySAM;
import ballistix.common.settings.BallistixConstants;
import ballistix.common.tile.radar.TileFireControlRadar;
import ballistix.common.tile.turret.GenericTileTurret;
import ballistix.registers.BallistixDamageTypes;
import ballistix.registers.BallistixSounds;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import voltaic.Voltaic;
import voltaic.api.multiblock.subnodebased.TileMultiSubnode;
import voltaic.prefab.utilities.BlockEntityUtils;

public abstract class VirtualProjectile {
    public float speed;
    public Vec3 position;
    public Vec3 deltaMovement;
    public final float range;
    public final boolean canHitPlayers;
    public final UUID id;
    protected boolean hasExploded = false;
    protected boolean isSpawned = false;
    public float distanceTraveled = 0.0f;
    protected int tickCount = 0;
    protected int entityId = -1;

    protected VirtualProjectile(float speed, Vec3 position, Vec3 deltaMovement, float range, boolean canHitPlayers, float distanceTraveled, UUID id, boolean hasExploded, boolean isSpawned, int entityId) {
        this(speed, position, deltaMovement, range, canHitPlayers, id);
        this.distanceTraveled = distanceTraveled;
        this.hasExploded = hasExploded;
        this.isSpawned = isSpawned;
        this.entityId = entityId;
    }

    public VirtualProjectile(float speed, Vec3 position, Vec3 deltaMovement, float range, boolean canHitPlayers, UUID id) {
        this.speed = speed;
        this.position = position;
        this.deltaMovement = deltaMovement;
        this.range = range;
        this.canHitPlayers = canHitPlayers;
        this.id = id;
    }

    public void tick(ServerLevel level) {
        Entity entity;
        BlockState state;
        ++this.tickCount;
        if (this.tickCount > 30 && this.deltaMovement.m_82553_() <= 0.0) {
            this.hasExploded = true;
            return;
        }
        if (this.distanceTraveled >= this.range + 5.0f) {
            this.onReachMaxDistance((Level)level);
            this.hasExploded = true;
            return;
        }
        if (this.hasExploded) {
            return;
        }
        BlockPos projected = this.projectMovementForCollision(level);
        if (projected != null && !(state = level.m_8055_(projected)).m_60812_((BlockGetter)level, projected).m_83281_() && !this.isInValidBlockstate(projected, level)) {
            this.onHitBlock((Level)level, projected);
            this.hasExploded = true;
            return;
        }
        this.updatePosition(level);
        AABB box = this.getBoundingBox().m_82400_((double)this.speed);
        for (VirtualMissile missile : MissileManager.getMissilesForLevel((ResourceKey<Level>)level.m_46472_())) {
            if (missile.hasExploded() || !missile.getBoundingBox().m_82381_(box)) continue;
            this.onHitMissile((Level)level, missile);
            this.hasExploded = true;
            return;
        }
        if (this.canHitPlayers) {
            LivingEntity selected = null;
            double lastMag = 0.0;
            for (LivingEntity entity2 : level.m_45976_(LivingEntity.class, box)) {
                double deltaX = entity2.m_20185_() - this.position.f_82479_;
                double deltaY = entity2.m_20186_() - this.position.f_82480_;
                double deltaZ = entity2.m_20189_() - this.position.f_82481_;
                double mag = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
                if (selected == null) {
                    selected = entity2;
                    lastMag = mag;
                    continue;
                }
                if (!(mag < lastMag)) continue;
                selected = entity2;
            }
            if (selected != null) {
                this.onHitLiving((Level)level, selected);
                this.hasExploded = true;
                return;
            }
        }
        this.distanceTraveled += this.speed;
        if (!this.isSpawned && level.m_46805_(this.blockPosition()) && level.m_143340_(this.blockPosition()) && level.m_7967_(entity = this.makeNewEntity((Level)level))) {
            this.setSpawned(true, entity.m_19879_());
        }
        if (this.isSpawned && (!level.m_46805_(this.blockPosition()) || level.m_6815_(this.entityId) == null)) {
            this.setSpawned(false, -1);
        }
    }

    protected boolean isInValidBlockstate(BlockPos pos, ServerLevel world) {
        if (pos == null) {
            return true;
        }
        BlockEntity blockentity = world.m_7702_(pos);
        return blockentity instanceof GenericTileTurret;
    }

    public void updatePosition(ServerLevel level) {
        this.position = new Vec3(this.position.f_82479_ + this.deltaMovement.f_82479_ * (double)this.speed, this.position.f_82480_ + this.deltaMovement.f_82480_ * (double)this.speed, this.position.f_82481_ + this.deltaMovement.f_82481_ * (double)this.speed);
    }

    public abstract void onHitMissile(Level var1, VirtualMissile var2);

    public abstract void onHitLiving(Level var1, LivingEntity var2);

    public abstract void onHitBlock(Level var1, BlockPos var2);

    public void onReachMaxDistance(Level world) {
    }

    public abstract AABB getBoundingBox();

    public BlockPos blockPosition() {
        return new BlockPos((int)Math.floor(this.position.f_82479_), (int)Math.floor(this.position.f_82480_), (int)Math.floor(this.position.f_82481_));
    }

    public void setSpawned(boolean spawned, int id) {
        this.isSpawned = spawned;
        this.entityId = id;
    }

    public boolean hasExploded() {
        return this.hasExploded;
    }

    public abstract Entity makeNewEntity(Level var1);

    @Nullable
    public BlockPos projectMovementForCollision(ServerLevel world) {
        Vec3 currPos = this.position.m_82490_(1.0);
        int iterations = Math.abs((int)Math.ceil(this.speed));
        for (int i = 0; i < iterations; ++i) {
            BlockPos pos = new BlockPos((int)Math.floor(currPos.f_82479_), (int)Math.floor(currPos.f_82480_), (int)Math.floor(currPos.f_82481_));
            BlockState state = world.m_8055_(pos);
            if (!state.m_60812_((BlockGetter)world, this.blockPosition()).m_83281_() && !this.isInValidBlockstate(pos, world)) {
                return pos;
            }
            currPos.m_82549_(this.deltaMovement);
        }
        return null;
    }

    public static class VirtualSAM
    extends VirtualProjectile {
        public static final Codec<VirtualSAM> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("speed").forGetter(instance0 -> Float.valueOf(instance0.speed)), (App)Vec3.f_231074_.fieldOf("position").forGetter(instance0 -> instance0.position), (App)Vec3.f_231074_.fieldOf("movement").forGetter(instance0 -> instance0.deltaMovement), (App)Codec.FLOAT.fieldOf("range").forGetter(instance0 -> Float.valueOf(instance0.range)), (App)Codec.FLOAT.fieldOf("distancetraveled").forGetter(instance0 -> Float.valueOf(instance0.distanceTraveled)), (App)UUIDUtil.f_235867_.fieldOf("id").forGetter(instance0 -> instance0.id), (App)Codec.BOOL.fieldOf("hasexploded").forGetter(instance0 -> instance0.hasExploded), (App)Codec.BOOL.fieldOf("hasspawned").forGetter(instance0 -> instance0.isSpawned), (App)Codec.INT.fieldOf("entityid").forGetter(instance0 -> instance0.entityId), (App)BlockPos.f_121852_.fieldOf("radarpos").forGetter(instance0 -> instance0.radarPos), (App)Codec.INT.fieldOf("variant").forGetter(instance0 -> instance0.variant)).apply((Applicative)instance, VirtualSAM::new));
        private BlockPos radarPos = BlockEntityUtils.OUT_OF_REACH;
        private final int variant;
        private TileFireControlRadar radar = null;

        protected VirtualSAM(float speed, Vec3 position, Vec3 deltaMovement, float range, float distanceTraveled, UUID id, boolean hasExploded, boolean isSpawned, int entityId, BlockPos radarPos, int variant) {
            super(speed, position, deltaMovement, range, true, distanceTraveled, id, hasExploded, isSpawned, entityId);
            this.radarPos = radarPos;
            this.variant = variant;
        }

        public VirtualSAM(float speed, Vec3 position, Vec3 deltaMovement, float range, BlockPos radarPos, int variant) {
            super(speed, position, deltaMovement, range, false, UUID.randomUUID());
            this.radarPos = radarPos;
            this.variant = variant;
        }

        @Override
        protected boolean isInValidBlockstate(BlockPos pos, ServerLevel world) {
            if (this.variant == 0) {
                return super.isInValidBlockstate(pos, world);
            }
            if (pos == null) {
                return true;
            }
            BlockEntity blockentity = world.m_7702_(pos);
            if (blockentity instanceof ILauncherPlatform || blockentity instanceof ILauncherSupportFrame) {
                return true;
            }
            if (blockentity instanceof TileMultiSubnode) {
                TileMultiSubnode subnode = (TileMultiSubnode)blockentity;
                BlockEntity owner = world.m_7702_((BlockPos)subnode.parentPos.getValue());
                return owner instanceof ILauncherPlatform || owner instanceof ILauncherSupportFrame;
            }
            return false;
        }

        @Override
        public void onHitMissile(Level world, VirtualMissile missile) {
            double d = Voltaic.RANDOM.nextDouble();
            double d2 = this.variant == 0 ? BallistixConstants.SAM_CHANCE_TO_DESTROY : BallistixConstants.ANTIBALLISTICMISSILE_CHANCE_TO_DESTROY;
            if (d < d2) {
                MissileManager.removeMissile((ResourceKey<Level>)world.m_46472_(), missile.getId());
            }
            world.m_5594_(null, this.blockPosition(), SoundEvents.f_11913_, SoundSource.HOSTILE, 2.0f, 1.0f);
        }

        @Override
        public void onReachMaxDistance(Level world) {
            world.m_254877_(null, null, null, this.position.f_82479_, this.position.f_82480_, this.position.f_82481_, 2.0f, false, Level.ExplosionInteraction.BLOCK);
        }

        @Override
        public void onHitBlock(Level world, BlockPos block) {
            world.m_254877_(null, null, null, this.position.f_82479_, this.position.f_82480_, this.position.f_82481_, 2.0f, false, Level.ExplosionInteraction.BLOCK);
        }

        @Override
        public void onHitLiving(Level world, LivingEntity entity) {
            world.m_254877_(null, null, null, this.position.f_82479_, this.position.f_82480_, this.position.f_82481_, 2.0f, false, Level.ExplosionInteraction.BLOCK);
        }

        @Override
        public AABB getBoundingBox() {
            return this.variant == 0 ? new AABB(this.position.f_82479_ - 0.25 * (double)this.speed, this.position.f_82480_, this.position.f_82481_ - (double)(0.25f * this.speed), this.position.f_82479_ + (double)(0.25f * this.speed), this.position.f_82480_ + (double)(1.0f * this.speed), this.position.f_82481_ + (double)(0.25f * this.speed)) : new AABB(this.position.f_82479_ - (double)(0.25f * this.speed), this.position.f_82480_, this.position.f_82481_ - (double)(0.25f * this.speed), this.position.f_82479_ + (double)(0.25f * this.speed), this.position.f_82480_ + (double)(2.0f * this.speed), this.position.f_82481_ + (double)(0.25f * this.speed));
        }

        @Override
        public Entity makeNewEntity(Level world) {
            EntitySAM sam = new EntitySAM(world);
            sam.m_146884_(this.position);
            sam.m_20256_(this.deltaMovement);
            sam.id = this.id;
            sam.speed = this.speed;
            sam.variant = this.variant;
            return sam;
        }

        @Override
        public void updatePosition(ServerLevel level) {
            double maxTurnRadians;
            BlockEntity blockEntity;
            float minSpeed;
            float topSpeed = this.variant == 0 ? BallistixConstants.SAM_TOP_SPEED : BallistixConstants.ANTIBALLISTICMISSILE_TOP_SPEED;
            float f = minSpeed = this.variant == 0 ? topSpeed * BallistixConstants.SAM_MINTURNSPEED_PERC : topSpeed * BallistixConstants.ANTIBALLISTICMISSILE_MINTURNSPEED_PERC;
            if (this.radarPos == null || this.radarPos.equals((Object)BlockEntityUtils.OUT_OF_REACH) || this.speed < minSpeed) {
                super.updatePosition(level);
                return;
            }
            if (this.radar == null && (blockEntity = level.m_7702_(this.radarPos)) instanceof TileFireControlRadar) {
                TileFireControlRadar radar;
                this.radar = radar = (TileFireControlRadar)blockEntity;
            }
            if (this.radar != null && this.radar.m_58901_()) {
                this.radar = null;
            }
            if (this.radar == null || this.radar.m_58901_() || this.radar.tracking == null || this.radar.tracking.hasExploded()) {
                super.updatePosition(level);
                return;
            }
            VirtualMissile tracking = this.radar.tracking;
            Vec3 trackingVector = tracking.deltaMovement;
            float trackingSpeed = 0.0f;
            double timeToIntercept = TileFireControlRadar.getTimeToIntercept(tracking.position, trackingVector, trackingSpeed, topSpeed, this.position);
            if (timeToIntercept <= 0.0) {
                super.updatePosition(level);
                return;
            }
            Vec3 interceptionPos = tracking.position.m_82549_(trackingVector.m_82490_((double)trackingSpeed).m_82490_(timeToIntercept));
            double deltaX = interceptionPos.f_82479_ - this.position.f_82479_;
            double deltaY = interceptionPos.f_82480_ - this.position.f_82480_;
            double deltaZ = interceptionPos.f_82481_ - this.position.f_82481_;
            Vec3 desiredVector = new Vec3(deltaX, deltaY, deltaZ).m_82541_();
            Vec3 currVector = this.deltaMovement.m_82541_();
            double dotProduct = desiredVector.m_82526_(currVector);
            double d = maxTurnRadians = this.variant == 0 ? BallistixConstants.SAM_ENTITY_TURNINGSPEEDRADIANS : BallistixConstants.ANTIBALLISTICMISSILE_ENTITY_TURNINGSPEEDRADIANS;
            if (dotProduct != 0.0) {
                if (Math.acos(dotProduct) <= maxTurnRadians) {
                    this.deltaMovement = desiredVector;
                } else {
                    Vec3 perpVector = currVector.m_82537_(desiredVector).m_82537_(currVector).m_82541_();
                    Vec3 result = currVector.m_82490_(Math.cos(maxTurnRadians)).m_82549_(perpVector.m_82490_(Math.sin(maxTurnRadians)));
                    this.deltaMovement = result.m_82541_();
                }
            }
            super.updatePosition(level);
        }

        @Override
        public void tick(ServerLevel level) {
            float topSpeed;
            super.tick(level);
            float f = topSpeed = this.variant == 0 ? BallistixConstants.SAM_TOP_SPEED : BallistixConstants.ANTIBALLISTICMISSILE_TOP_SPEED;
            if (this.speed < topSpeed) {
                this.speed += this.variant == 0 ? BallistixConstants.SAM_ACCELERATION : BallistixConstants.ANTIBALLISTICMISSILE_ACCELERATION;
            }
            if (this.speed >= topSpeed) {
                return;
            }
            float x = (float)this.position.f_82479_;
            float y = (float)this.position.f_82480_;
            float z = (float)this.position.f_82481_;
            float motionX = (float)((double)this.speed * this.deltaMovement.f_82479_);
            float motionY = (float)((double)this.speed * this.deltaMovement.f_82480_);
            float motionZ = (float)((double)this.speed * this.deltaMovement.f_82481_);
            x -= motionX;
            y -= motionY;
            z -= motionZ;
            for (int i = 0; i < 3; ++i) {
                level.m_7106_((ParticleOptions)new ParticleOptionsMissileSmoke().setParameters(1.0f, 1.0f, 1.0f, 0.3f, 50, true), (double)x, (double)y, (double)z, (double)(-motionX) * (0.4 + 0.2 * Voltaic.RANDOM.nextDouble()), (double)(-motionY) * (0.4 + 0.2 * Voltaic.RANDOM.nextDouble()), (double)(-motionZ) * (0.4 + 0.2 * Voltaic.RANDOM.nextDouble()));
            }
        }
    }

    public static class VirtualRailgunRound
    extends VirtualProjectile {
        public static final Codec<VirtualRailgunRound> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("speed").forGetter(instance0 -> Float.valueOf(instance0.speed)), (App)Vec3.f_231074_.fieldOf("position").forGetter(instance0 -> instance0.position), (App)Vec3.f_231074_.fieldOf("movement").forGetter(instance0 -> instance0.deltaMovement), (App)Codec.FLOAT.fieldOf("range").forGetter(instance0 -> Float.valueOf(instance0.range)), (App)Codec.FLOAT.fieldOf("distancetraveled").forGetter(instance0 -> Float.valueOf(instance0.distanceTraveled)), (App)UUIDUtil.f_235867_.fieldOf("id").forGetter(instance0 -> instance0.id), (App)Codec.BOOL.fieldOf("hasexploded").forGetter(instance0 -> instance0.hasExploded), (App)Codec.BOOL.fieldOf("hasspawned").forGetter(instance0 -> instance0.isSpawned), (App)Codec.INT.fieldOf("entityid").forGetter(instance0 -> instance0.entityId)).apply((Applicative)instance, VirtualRailgunRound::new));

        protected VirtualRailgunRound(float speed, Vec3 position, Vec3 deltaMovement, float range, float distanceTraveled, UUID id, boolean hasExploded, boolean isSpawned, int entityId) {
            super(speed, position, deltaMovement, range, true, distanceTraveled, id, hasExploded, isSpawned, entityId);
        }

        public VirtualRailgunRound(float speed, Vec3 position, Vec3 deltaMovement, float range) {
            super(speed, position, deltaMovement, range, true, UUID.randomUUID());
        }

        @Override
        public void onHitMissile(Level world, VirtualMissile missile) {
            MissileManager.removeMissile((ResourceKey<Level>)world.m_46472_(), missile.getId());
            world.m_5594_(null, this.blockPosition(), SoundEvents.f_11913_, SoundSource.HOSTILE, 2.0f, 1.0f);
        }

        @Override
        public void onHitLiving(Level world, LivingEntity entity) {
            entity.m_6469_(entity.m_269291_().m_269079_(BallistixDamageTypes.RAILGUN_ROUND), 20.0f);
        }

        @Override
        public void onHitBlock(Level world, BlockPos block) {
            BlockState state = world.m_8055_(block);
            if (state.m_60800_((BlockGetter)world, block) < 50.0f && !state.m_60713_(Blocks.f_50752_)) {
                world.m_46961_(block, false);
            }
            world.m_5594_(null, block, (SoundEvent)BallistixSounds.SOUND_RODHITTINGGROUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }

        @Override
        public AABB getBoundingBox() {
            return new AABB(this.position.f_82479_ - (double)0.05f, this.position.f_82480_, this.position.f_82481_ - (double)0.05f, this.position.f_82479_ + (double)0.05f, this.position.f_82480_ + (double)0.1f, this.position.f_82481_ + (double)0.05f);
        }

        @Override
        public Entity makeNewEntity(Level world) {
            EntityRailgunRound railgunround = new EntityRailgunRound(world);
            railgunround.m_146884_(this.position);
            railgunround.m_20256_(this.deltaMovement);
            railgunround.id = this.id;
            railgunround.speed = this.speed;
            return railgunround;
        }
    }

    public static class VirtualBullet
    extends VirtualProjectile {
        public static final Codec<VirtualBullet> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("speed").forGetter(instance0 -> Float.valueOf(instance0.speed)), (App)Vec3.f_231074_.fieldOf("position").forGetter(instance0 -> instance0.position), (App)Vec3.f_231074_.fieldOf("movement").forGetter(instance0 -> instance0.deltaMovement), (App)Codec.FLOAT.fieldOf("range").forGetter(instance0 -> Float.valueOf(instance0.range)), (App)Codec.FLOAT.fieldOf("distancetraveled").forGetter(instance0 -> Float.valueOf(instance0.distanceTraveled)), (App)UUIDUtil.f_235867_.fieldOf("id").forGetter(instance0 -> instance0.id), (App)Codec.BOOL.fieldOf("hasexploded").forGetter(instance0 -> instance0.hasExploded), (App)Codec.BOOL.fieldOf("hasspawned").forGetter(instance0 -> instance0.isSpawned), (App)Codec.INT.fieldOf("entityid").forGetter(instance0 -> instance0.entityId)).apply((Applicative)instance, VirtualBullet::new));

        protected VirtualBullet(float speed, Vec3 position, Vec3 deltaMovement, float range, float distanceTraveled, UUID id, boolean hasExploded, boolean isSpawned, int entityId) {
            super(speed, position, deltaMovement, range, true, distanceTraveled, id, hasExploded, isSpawned, entityId);
        }

        public VirtualBullet(float speed, Vec3 position, Vec3 deltaMovement, float range) {
            super(speed, position, deltaMovement, range, true, UUID.randomUUID());
        }

        @Override
        public void onHitMissile(Level world, VirtualMissile missile) {
            missile.health -= 1.0f;
            if (missile.health <= 0.0f) {
                world.m_5594_(null, this.blockPosition(), SoundEvents.f_11913_, SoundSource.HOSTILE, 2.0f, 1.0f);
            }
        }

        @Override
        public void onHitLiving(Level world, LivingEntity entity) {
            entity.m_6469_(entity.m_269291_().m_269079_(BallistixDamageTypes.CIWS_BULLET), 10.0f);
        }

        @Override
        public void onHitBlock(Level world, BlockPos block) {
        }

        @Override
        public AABB getBoundingBox() {
            return new AABB(this.position.f_82479_ - (double)0.05f, this.position.f_82480_, this.position.f_82481_ - (double)0.05f, this.position.f_82479_ + (double)0.05f, this.position.f_82480_ + (double)0.1f, this.position.f_82481_ + (double)0.05f);
        }

        @Override
        public Entity makeNewEntity(Level world) {
            EntityBullet bullet = new EntityBullet(world);
            bullet.m_146884_(this.position);
            bullet.m_20256_(this.deltaMovement);
            bullet.id = this.id;
            bullet.speed = this.speed;
            return bullet;
        }
    }
}

