/*
 * Decompiled with CFR 0.152.
 */
package ballistix.client.render.tile;

import ballistix.client.BallistixClientRegister;
import ballistix.common.tile.turret.antimissile.TileTurretLaser;
import ballistix.common.tile.turret.antimissile.TileTurretSAM;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import voltaic.client.VoltaicClientRegister;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.MathUtils;

public class RenderLaserTurret
extends AbstractTileRenderer<TileTurretLaser> {
    public RenderLaserTurret(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(@NotNull TileTurretLaser tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BakedModel model = this.getModel(BallistixClientRegister.MODEL_LASERTURRET_BALLJOINT);
        Vec3 rotVec = (Vec3)tileEntityIn.turretRotation.getValue();
        double yRot = TileTurretSAM.getXZAngleRadians(rotVec) / Math.PI * 180.0;
        double yAng = Math.asin(rotVec.f_82480_);
        float elevRot = (float)(yAng / Math.PI * 180.0);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 0.5, 0.5);
        matrixStackIn.m_252781_(MathUtils.rotQuaternionDeg((float)0.0f, (float)((float)(-yRot)), (float)0.0f));
        matrixStackIn.m_85837_(-0.5, -0.5, -0.5);
        Minecraft.m_91087_().m_91289_().m_110937_().m_234379_((BlockAndTintGetter)tileEntityIn.m_58904_(), model, tileEntityIn.m_58900_(), tileEntityIn.m_58899_(), matrixStackIn, bufferIn.m_6299_(RenderType.m_110451_()), false, tileEntityIn.m_58904_().f_46441_, new Random().nextLong(), 0);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 0.8125, 0.5);
        matrixStackIn.m_252781_(MathUtils.rotQuaternionDeg((float)0.0f, (float)((float)(-yRot)), (float)elevRot));
        matrixStackIn.m_85837_(-0.5, -0.8125, -0.5);
        model = this.getModel(BallistixClientRegister.MODEL_LASERTURRET_HEAD);
        Minecraft.m_91087_().m_91289_().m_110937_().m_234379_((BlockAndTintGetter)tileEntityIn.m_58904_(), model, tileEntityIn.m_58900_(), tileEntityIn.m_58899_(), matrixStackIn, bufferIn.m_6299_(RenderType.m_110451_()), false, tileEntityIn.m_58904_().f_46441_, new Random().nextLong(), 0);
        matrixStackIn.m_85849_();
        if (((Boolean)tileEntityIn.hasNoPower.getValue()).booleanValue() || !((Boolean)tileEntityIn.firing.getValue()).booleanValue()) {
            return;
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 0.8125, 0.5);
        matrixStackIn.m_252781_(MathUtils.rotQuaternionDeg((float)0.0f, (float)((float)(-yRot)), (float)elevRot));
        matrixStackIn.m_85837_(-0.5, -0.8125, -0.5);
        Vec3 start = tileEntityIn.getProjectileLaunchPosition();
        Vec3 end = (Vec3)tileEntityIn.targetPos.getValue();
        double deltaX = end.f_82479_ - start.f_82479_;
        double deltaY = end.f_82480_ - start.f_82480_;
        double deltaZ = end.f_82481_ - start.f_82481_;
        double mag = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        AABB box = new AABB(0.5, 1.0, 0.46875, mag, 1.0625, 0.53125);
        TextureAtlasSprite sprite = VoltaicClientRegister.whiteSprite();
        RenderingUtils.renderFilledBoxNoOverlay((PoseStack)matrixStackIn, (VertexConsumer)bufferIn.m_6299_(RenderType.m_110451_()), (AABB)box, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)sprite.m_118409_(), (float)sprite.m_118411_(), (float)sprite.m_118410_(), (float)sprite.m_118412_(), (int)combinedLightIn, (boolean[])RenderingUtils.ALL_FACES);
        matrixStackIn.m_85849_();
    }

    public boolean shouldRenderOffScreen(TileTurretLaser blockEntity) {
        return true;
    }

    public boolean shouldRender(TileTurretLaser blockEntity, Vec3 cameraPos) {
        return true;
    }
}

