/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.entity;

import ballistix.registers.BallistixEntities;
import com.google.common.collect.Lists;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class EntityBallistixFallingBlock
extends ThrowableProjectile
implements IEntityAdditionalSpawnData {
    private BlockState blockState = Blocks.f_49992_.m_49966_();
    public int time;
    public boolean dropItem = true;
    private boolean hurtEntities;
    private int fallDamageMax = 40;
    private float fallDamageAmount = 2.0f;
    public CompoundTag blockData;
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.m_135353_(EntityBallistixFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public EntityBallistixFallingBlock(EntityType<? extends EntityBallistixFallingBlock> entityType, Level level) {
        super(entityType, level);
    }

    public EntityBallistixFallingBlock(Level world, double x, double y, double z, BlockState blockState) {
        this((EntityType<? extends EntityBallistixFallingBlock>)((EntityType)BallistixEntities.ENTITY_BALLISTIXFALLINGBLOCK.get()), world);
        this.blockState = blockState;
        this.f_19850_ = true;
        this.hurtEntities = true;
        this.m_6034_(x, y + (double)((1.0f - this.m_20206_()) / 2.0f), z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.setStartPos(this.m_20183_());
    }

    public boolean m_6097_() {
        return false;
    }

    public void setStartPos(BlockPos pos) {
        this.f_19804_.m_135381_(DATA_START_POS, (Object)pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockPos getStartPos() {
        return (BlockPos)this.f_19804_.m_135370_(DATA_START_POS);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_START_POS, (Object)BlockPos.f_121853_);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
        tag.m_128405_("Time", this.time);
        tag.m_128379_("DropItem", this.dropItem);
        tag.m_128379_("HurtEntities", this.hurtEntities);
        tag.m_128350_("FallHurtAmount", this.fallDamageAmount);
        tag.m_128405_("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            tag.m_128365_("TileEntityData", (Tag)this.blockData);
        }
    }

    protected void m_8060_(BlockHitResult result) {
        BlockState state = this.m_9236_().m_8055_(result.m_82425_());
        if (!state.m_60795_() && !state.m_278721_()) {
            if (!this.m_9236_().f_46443_ && !state.m_60713_(Blocks.f_50322_)) {
                this.m_9236_().m_46597_(this.m_20183_(), this.blockState);
            }
            this.m_6089_();
        }
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        int i;
        if (this.hurtEntities && (i = Mth.m_14167_((float)(fallDistance - 1.0f))) > 0) {
            ArrayList list = Lists.newArrayList((Iterable)this.m_9236_().m_45933_((Entity)this, this.m_20191_()));
            boolean flag = this.blockState.m_204336_(BlockTags.f_13033_);
            for (Entity entity : list) {
                entity.m_6469_(flag ? entity.m_269291_().m_269230_(entity) : entity.m_269291_().m_269564_(entity), (float)Math.min(Mth.m_14143_((float)((float)i * this.fallDamageAmount)), this.fallDamageMax));
            }
        }
        return false;
    }

    protected void m_7378_(CompoundTag tag) {
        BlockState.f_61039_.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("BlockState")).result().ifPresent(pair -> {
            this.blockState = (BlockState)pair.getFirst();
        });
        this.time = tag.m_128451_("Time");
        if (tag.m_128425_("HurtEntities", 99)) {
            this.hurtEntities = tag.m_128471_("HurtEntities");
            this.fallDamageAmount = tag.m_128457_("FallHurtAmount");
            this.fallDamageMax = tag.m_128451_("FallHurtMax");
        } else if (this.blockState.m_204336_(BlockTags.f_13033_)) {
            this.hurtEntities = true;
        }
        if (tag.m_128425_("DropItem", 99)) {
            this.dropItem = tag.m_128471_("DropItem");
        }
        if (tag.m_128425_("TileEntityData", 10)) {
            this.blockData = tag.m_128469_("TileEntityData");
        }
        if (this.blockState.m_60795_()) {
            this.blockState = Blocks.f_49992_.m_49966_();
        }
    }

    protected float m_7139_() {
        return 0.04f;
    }

    public void setHurtsEntities(boolean shouldHurt) {
        this.hurtEntities = shouldHurt;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6051_() {
        return false;
    }

    public void m_7976_(CrashReportCategory report) {
        super.m_7976_(report);
        report.m_128159_("Immitating BlockState", (Object)this.blockState.toString());
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public boolean m_6127_() {
        return true;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag tag = new CompoundTag();
        this.m_7380_(tag);
        buffer.m_130079_(tag);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.m_7378_(buffer.m_130260_());
    }

    public boolean m_6783_(double distance) {
        return super.m_6783_(distance);
    }

    public boolean m_6000_(double x, double y, double z) {
        return super.m_6000_(x, y, z);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

