/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.event;

import ballistix.api.blast.AntigravedChunk;
import ballistix.api.capability.CapabilityActiveBullets;
import ballistix.api.capability.CapabilityActiveMissiles;
import ballistix.api.capability.CapabilityActiveRailgunRounds;
import ballistix.api.capability.CapabilityActiveSAMs;
import ballistix.api.capability.CapabilityAntigravedChunks;
import ballistix.api.capability.CapabilitySiloRegistry;
import ballistix.api.missile.MissileManager;
import ballistix.common.command.CommandClearAntigravityChunks;
import ballistix.common.command.CommandClearBullets;
import ballistix.common.command.CommandClearMissiles;
import ballistix.common.command.CommandClearRailgunRounds;
import ballistix.common.command.CommandClearSAMs;
import ballistix.common.entity.EntityBallistixFallingBlock;
import ballistix.common.packet.NetworkHandler;
import ballistix.common.packet.type.client.PacketPushPlayer;
import ballistix.common.settings.BallistixConstants;
import ballistix.registers.BallistixCapabilities;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;

@Mod.EventBusSubscriber(modid="ballistix", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerEventHandler {
    @SubscribeEvent
    public static void attachOverworldCapability(AttachCapabilitiesEvent<Level> event) {
        Level world = (Level)event.getObject();
        if (!world.getCapability(BallistixCapabilities.SILO_REGISTRY).isPresent() && world.m_46472_().equals((Object)Level.f_46428_)) {
            event.addCapability(new ResourceLocation("ballistix", "siloregistry"), (ICapabilityProvider)new CapabilitySiloRegistry());
        }
        if (!world.getCapability(BallistixCapabilities.ACTIVE_MISSILES).isPresent() && world.m_46472_().equals((Object)Level.f_46428_)) {
            event.addCapability(new ResourceLocation("ballistix", "activemissiles"), (ICapabilityProvider)new CapabilityActiveMissiles());
        }
        if (!world.getCapability(BallistixCapabilities.ACTIVE_BULLETS).isPresent() && world.m_46472_().equals((Object)Level.f_46428_)) {
            event.addCapability(new ResourceLocation("ballistix", "activebullets"), (ICapabilityProvider)new CapabilityActiveBullets());
        }
        if (!world.getCapability(BallistixCapabilities.ACTIVE_RAILGUN_ROUNDS).isPresent() && world.m_46472_().equals((Object)Level.f_46428_)) {
            event.addCapability(new ResourceLocation("ballistix", "activerailgunrounds"), (ICapabilityProvider)new CapabilityActiveRailgunRounds());
        }
        if (!world.getCapability(BallistixCapabilities.ACTIVE_SAMS).isPresent() && world.m_46472_().equals((Object)Level.f_46428_)) {
            event.addCapability(new ResourceLocation("ballistix", "activesams"), (ICapabilityProvider)new CapabilityActiveSAMs());
        }
        if (!world.getCapability(BallistixCapabilities.ANTIGRAVED_CHUNKS).isPresent()) {
            event.addCapability(new ResourceLocation("ballistix", "antigravedchunks"), (ICapabilityProvider)new CapabilityAntigravedChunks());
        }
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandClearMissiles.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        CommandClearBullets.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        CommandClearRailgunRounds.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        CommandClearSAMs.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        CommandClearAntigravityChunks.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void handleAntigravedChunks(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Level level = event.level;
        if (level.m_5776_()) {
            return;
        }
        LazyOptional lazy = level.getCapability(BallistixCapabilities.ANTIGRAVED_CHUNKS);
        if (!lazy.isPresent()) {
            return;
        }
        HashSet<AntigravedChunk> chunks = ((CapabilityAntigravedChunks)lazy.resolve().get()).activeChunks;
        Iterator<AntigravedChunk> iterator = chunks.iterator();
        while (iterator.hasNext()) {
            AntigravedChunk chunk = iterator.next();
            if (!level.m_7726_().m_5563_(chunk.getPos().f_45578_, chunk.getPos().f_45579_)) continue;
            chunk.decrementTime();
            LevelChunk levelChunk = level.m_6325_(chunk.getPos().f_45578_, chunk.getPos().f_45579_);
            AABB box = new AABB(new BlockPos(chunk.getPos().m_45604_(), levelChunk.m_141937_(), chunk.getPos().m_45605_()), new BlockPos(chunk.getPos().m_45608_(), levelChunk.m_151558_(), chunk.getPos().m_45609_()).m_7918_(1, 1, 1));
            MissileManager.getMissilesForLevel((ResourceKey<Level>)level.m_46472_()).forEach(missile -> {
                if (!missile.getBoundingBox().m_82381_(box) || missile.position.f_82480_ > (double)BallistixConstants.EXPLOSIVE_ANTIGRAVITY_MAXHEIGHT) {
                    return;
                }
                missile.position = missile.position.m_82520_(0.0, 0.04, 0.0);
            });
            MissileManager.getBulletsForLevel((ResourceKey<Level>)level.m_46472_()).forEach(bullet -> {
                if (!bullet.getBoundingBox().m_82381_(box) || bullet.position.f_82480_ > (double)BallistixConstants.EXPLOSIVE_ANTIGRAVITY_MAXHEIGHT) {
                    return;
                }
                bullet.position = bullet.position.m_82520_(0.0, 0.04, 0.0);
            });
            MissileManager.getRailgunRoundsForLevel((ResourceKey<Level>)level.m_46472_()).forEach(round -> {
                if (!round.getBoundingBox().m_82381_(box) || round.position.f_82480_ > (double)BallistixConstants.EXPLOSIVE_ANTIGRAVITY_MAXHEIGHT) {
                    return;
                }
                round.position = round.position.m_82520_(0.0, 0.04, 0.0);
            });
            MissileManager.getSAMsForLevel((ResourceKey<Level>)level.m_46472_()).forEach(missile -> {
                if (!missile.getBoundingBox().m_82381_(box) || missile.position.f_82480_ > (double)BallistixConstants.EXPLOSIVE_ANTIGRAVITY_MAXHEIGHT) {
                    return;
                }
                missile.position = missile.position.m_82520_(0.0, 0.04, 0.0);
            });
            List entities = level.m_45976_(Entity.class, box);
            for (Entity entity : entities) {
                if (!entity.m_6084_() || entity.m_20186_() > (double)BallistixConstants.EXPLOSIVE_ANTIGRAVITY_MAXHEIGHT) continue;
                if (entity instanceof ServerPlayer) {
                    ServerPlayer server = (ServerPlayer)entity;
                    NetworkHandler.CHANNEL.sendTo((Object)new PacketPushPlayer(server.m_20148_()), server.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                    continue;
                }
                entity.m_5997_(entity.m_20184_().f_82479_, 0.1 * BallistixConstants.EXPLOSIVE_ANTIGRAVITY_GRAVITYFACTOR, entity.m_20184_().f_82481_);
            }
            for (int i = 0; i < BallistixConstants.EXPLOSIVE_ANTIGRAVITY_MAXBLOCKCHECKS; ++i) {
                BlockState above;
                int x = level.f_46441_.m_216332_(0, 16);
                int y = level.f_46441_.m_216332_(levelChunk.m_141937_(), levelChunk.m_151558_());
                int z = level.f_46441_.m_216332_(0, 16);
                BlockPos pos = new BlockPos(chunk.getPos().m_45604_() + x, y, chunk.getPos().m_45609_() + z);
                BlockState state = level.m_8055_(pos);
                if (state.m_60795_() || state.m_278721_() || !(above = level.m_8055_(pos.m_7494_())).m_60795_() && !above.m_278721_()) continue;
                EntityBallistixFallingBlock movingBlock = new EntityBallistixFallingBlock(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, state);
                movingBlock.m_20334_(0.0, 0.04 * BallistixConstants.EXPLOSIVE_ANTIGRAVITY_GRAVITYFACTOR, 0.0);
                level.m_7967_((Entity)movingBlock);
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
            if (chunk.getTime() >= 0) continue;
            iterator.remove();
        }
    }
}

