/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.item;

import ballistix.api.silo.ILauncherControlPanel;
import ballistix.common.tile.turret.antimissile.util.TileTurretAntimissile;
import ballistix.prefab.utils.BallistixTextUtils;
import ballistix.registers.BallistixCreativeTabs;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import voltaic.api.multiblock.subnodebased.TileMultiSubnode;
import voltaic.prefab.item.ElectricItemProperties;
import voltaic.prefab.item.ItemElectric;
import voltaic.prefab.utilities.math.MathUtils;
import voltaic.prefab.utilities.object.Location;
import voltaic.prefab.utilities.object.TransferPack;

public class ItemRadarGun
extends ItemElectric {
    public static final double USAGE = 150.0;

    public ItemRadarGun() {
        super((ElectricItemProperties)new ElectricItemProperties().capacity(1666666.66667).receive(TransferPack.joulesVoltage((double)694.4444444458333, (double)120.0)).extract(TransferPack.joulesVoltage((double)694.4444444458333, (double)120.0)).m_41487_(1), BallistixCreativeTabs.MAIN, item -> Items.f_41852_);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        TileMultiSubnode subnode;
        BlockEntity blockEntity;
        if (context.m_43725_().f_46443_ || !stack.m_41784_().m_128441_("loc")) {
            return super.onItemUseFirst(stack, context);
        }
        BlockEntity tile = context.m_43725_().m_7702_(context.m_8083_());
        if (tile instanceof ILauncherControlPanel) {
            ILauncherControlPanel silo = (ILauncherControlPanel)tile;
            silo.setTargetFromDesignator(ItemRadarGun.getCoordiantes(stack));
        } else if (tile instanceof TileMultiSubnode && (blockEntity = (subnode = (TileMultiSubnode)tile).m_58904_().m_7702_((BlockPos)subnode.parentPos.getValue())) instanceof ILauncherControlPanel) {
            ILauncherControlPanel silo = (ILauncherControlPanel)blockEntity;
            silo.setTargetFromDesignator(ItemRadarGun.getCoordiantes(stack));
        } else if (tile instanceof TileTurretAntimissile) {
            TileTurretAntimissile turret = (TileTurretAntimissile)tile;
            if (turret.bindFireControlRadar(ItemRadarGun.getCoordiantes(stack))) {
                context.m_43723_().m_5661_((Component)BallistixTextUtils.chatMessage("radargun.turretsucess", new Object[0]), true);
            } else {
                context.m_43723_().m_5661_((Component)BallistixTextUtils.chatMessage("radargun.turrettoofar", new Object[0]), true);
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        TileMultiSubnode subnode;
        BlockEntity blockEntity;
        if (worldIn.f_46443_) {
            return super.m_7203_(worldIn, playerIn, handIn);
        }
        Location trace = MathUtils.getRaytracedBlock((Entity)playerIn);
        if (trace == null) {
            return super.m_7203_(worldIn, playerIn, handIn);
        }
        ItemStack radarGun = playerIn.m_21120_(handIn);
        if (this.getJoulesStored(radarGun) < 150.0) {
            return super.m_7203_(worldIn, playerIn, handIn);
        }
        if (trace.getTile((BlockGetter)playerIn.m_9236_()) instanceof ILauncherControlPanel || (blockEntity = trace.getTile((BlockGetter)playerIn.m_9236_())) instanceof TileMultiSubnode && (subnode = (TileMultiSubnode)blockEntity).m_58904_().m_7702_((BlockPos)subnode.parentPos.getValue()) instanceof ILauncherControlPanel || trace.getTile((BlockGetter)worldIn) instanceof TileTurretAntimissile) {
            return super.m_7203_(worldIn, playerIn, handIn);
        }
        ItemRadarGun.storeCoordiantes(radarGun, trace.toBlockPos());
        this.extractPower(radarGun, 150.0, false);
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.f_46443_ || !isSelected) {
            return;
        }
        Location trace = MathUtils.getRaytracedBlock((Entity)entityIn);
        if (trace == null) {
            return;
        }
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            player.m_5661_((Component)BallistixTextUtils.chatMessage("radargun.text", trace.toBlockPos().m_123344_()), true);
        }
    }

    public void m_7373_(ItemStack stack, Level context, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, context, tooltip, flagIn);
        if (stack.m_41782_() && stack.m_41783_().m_128441_("loc")) {
            tooltip.add((Component)BallistixTextUtils.tooltip("radargun.pos", ItemRadarGun.getCoordiantes(stack).m_123344_()).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)BallistixTextUtils.tooltip("radargun.notag", new Object[0]).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static void storeCoordiantes(ItemStack stack, BlockPos pos) {
        stack.m_41784_().m_128365_("loc", (Tag)NbtUtils.m_129224_((BlockPos)pos));
    }

    public static BlockPos getCoordiantes(ItemStack stack) {
        return NbtUtils.m_129239_((CompoundTag)stack.m_41784_().m_128469_("loc"));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_(newStack.m_41720_());
    }
}

