/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.tile.radar;

import ballistix.api.missile.MissileManager;
import ballistix.api.missile.virtual.VirtualMissile;
import ballistix.api.radar.IDetected;
import ballistix.common.block.subtype.SubtypeBallistixMachine;
import ballistix.common.block.subtype.SubtypeMissile;
import ballistix.common.inventory.container.ContainerSearchRadar;
import ballistix.common.settings.BallistixConstants;
import ballistix.common.tile.TileESMTower;
import ballistix.registers.BallistixItems;
import ballistix.registers.BallistixSounds;
import ballistix.registers.BallistixTiles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.world.ForgeChunkManager;
import voltaic.api.sound.SoundAPI;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.ListProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentForgeEnergy;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileSearchRadar
extends GenericTile {
    public final SingleProperty<Boolean> usingWhitelist = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "usingwhitelist", (Object)false));
    public final ListProperty<Integer> whitelistedFrequencies = (ListProperty)this.property((AbstractProperty)new ListProperty(PropertyTypes.INTEGER_LIST, "whitelistedfreqs", new ArrayList()));
    public final SingleProperty<Boolean> redstone = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "redstone", (Object)false));
    public final SingleProperty<Boolean> isRunning = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "isrunning", (Object)false));
    private final AABB searchArea = new AABB(this.m_58899_()).m_82400_((double)BallistixConstants.RADAR_RANGE);
    private final HashSet<VirtualMissile> trackedMissiles = new HashSet();
    public final HashSet<TileESMTower> trackedEsmTowers = new HashSet();
    public final HashSet<IDetected.Detected> detections = new HashSet();
    public double clientRotation;
    public double clientRotationSpeed;

    public TileSearchRadar(BlockPos pos, BlockState state) {
        super((BlockEntityType)BallistixTiles.TILE_RADAR.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).voltage(120.0).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).maxJoules(BallistixConstants.RADAR_USAGE * 20.0));
        this.addComponent((IComponent)new ComponentContainerProvider("searchradar", (GenericTile)this).createMenu((id, player) -> new ContainerSearchRadar((int)id, (Inventory)player, (Container)new SimpleContainer(0), (ContainerData)this.getCoordsArray())));
        this.addComponent((IComponent)new ComponentForgeEnergy((GenericTile)this));
    }

    public void tickServer(ComponentTickable tickable) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        this.isRunning.setValue((Object)(electro.getJoulesStored() > BallistixConstants.RADAR_USAGE / 20.0 && this.f_58857_.m_45517_(LightLayer.SKY, this.m_58899_()) > 0 ? 1 : 0));
        this.trackedMissiles.clear();
        this.trackedEsmTowers.clear();
        if (!((Boolean)this.isRunning.getValue()).booleanValue()) {
            if (((Boolean)this.redstone.getValue()).booleanValue()) {
                this.redstone.setValue((Object)false);
                this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            }
            TileESMTower.removeSearchRadar(this);
            return;
        }
        TileESMTower.addSearchRadar(this);
        electro.joules(electro.getJoulesStored() - BallistixConstants.RADAR_USAGE / 20.0);
        for (VirtualMissile missile : MissileManager.getMissilesForLevel((ResourceKey<Level>)this.f_58857_.m_46472_())) {
            if (!missile.getBoundingBox().m_82381_(this.searchArea) || ((Boolean)this.usingWhitelist.getValue()).booleanValue() && (!((Boolean)this.usingWhitelist.getValue()).booleanValue() || ((List)this.whitelistedFrequencies.getValue()).contains(missile.payloadData.frequency)) || missile.hasExploded()) continue;
            this.trackedMissiles.add(missile);
        }
        for (TileESMTower tower : TileESMTower.ESM_TOWERS.getOrDefault(this.f_58857_.m_46472_(), new HashSet())) {
            if (!new AABB(tower.m_58899_()).m_82381_(this.searchArea)) continue;
            this.trackedEsmTowers.add(tower);
        }
        if (this.trackedMissiles.isEmpty() && this.trackedEsmTowers.isEmpty() && ((Boolean)this.redstone.getValue()).booleanValue()) {
            this.redstone.setValue((Object)false);
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        } else if (!(this.trackedMissiles.isEmpty() && this.trackedEsmTowers.isEmpty() || ((Boolean)this.redstone.getValue()).booleanValue())) {
            this.redstone.setValue((Object)true);
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
        this.detections.clear();
        for (VirtualMissile missile : this.trackedMissiles) {
            this.detections.add(new IDetected.Detected(missile.position, (Item)BallistixItems.ITEMS_MISSILE.getValue((Object)SubtypeMissile.values()[missile.payloadData.missileType < 1 ? 0 : missile.payloadData.missileType - 1]), true));
        }
        for (TileESMTower tile : this.trackedEsmTowers) {
            this.detections.add(new IDetected.Detected(new Vec3((double)tile.m_58899_().m_123341_(), (double)tile.m_58899_().m_123342_(), (double)tile.m_58899_().m_123343_()), (Item)BallistixItems.ITEMS_BALLISTIXMACHINE.getValue((Object)SubtypeBallistixMachine.esmtower), false));
        }
    }

    public void tickClient(ComponentTickable tickable) {
        this.clientRotation += this.clientRotationSpeed;
        this.clientRotationSpeed = Mth.m_14008_((double)(this.clientRotationSpeed + 0.25 * (double)((Boolean)this.isRunning.getValue() != false ? 1 : -1)), (double)0.0, (double)10.0);
        if (tickable.getTicks() % 50L == 0L && ((Boolean)this.isRunning.getValue()).booleanValue()) {
            SoundAPI.playSound((SoundEvent)((SoundEvent)BallistixSounds.SOUND_RADAR.get()), (SoundSource)SoundSource.BLOCKS, (float)1.0f, (float)1.0f, (BlockPos)this.f_58858_);
        }
    }

    public int getSignal(Direction dir) {
        return (Boolean)this.redstone.getValue() != false ? 15 : 0;
    }

    public int getComparatorSignal() {
        if (!this.trackedMissiles.isEmpty() && !this.trackedEsmTowers.isEmpty()) {
            return 15;
        }
        if (this.trackedMissiles.isEmpty() && !this.trackedEsmTowers.isEmpty()) {
            return 8;
        }
        return 0;
    }

    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        if (!this.f_58857_.f_46443_) {
            TileESMTower.removeSearchRadar(this);
            ChunkPos pos = this.f_58857_.m_46865_(this.m_58899_()).m_7697_();
            ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_58857_), (String)"ballistix", (BlockPos)this.m_58899_(), (int)pos.f_45578_, (int)pos.f_45579_, (boolean)false, (boolean)true);
        }
    }

    public void onPlace(BlockState oldState, boolean isMoving) {
        super.onPlace(oldState, isMoving);
        if (!this.f_58857_.f_46443_) {
            ChunkPos pos = this.f_58857_.m_46865_(this.m_58899_()).m_7697_();
            ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_58857_), (String)"ballistix", (BlockPos)this.m_58899_(), (int)pos.f_45578_, (int)pos.f_45579_, (boolean)true, (boolean)true);
        }
    }
}

