/*
 * Decompiled with CFR 0.152.
 */
package ballistix.datagen;

import ballistix.datagen.client.BallistixBlockStateProvider;
import ballistix.datagen.client.BallistixItemModelsProvider;
import ballistix.datagen.client.BallistixLangKeyProvider;
import ballistix.datagen.client.BallistixSoundProvider;
import ballistix.datagen.server.BallistixLootTablesProvider;
import ballistix.datagen.server.recipe.BallistixRecipeProvider;
import ballistix.datagen.server.tags.BallistixTagsProvider;
import ballistix.registers.BallistixDamageTypes;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import voltaic.datagen.utils.client.BaseLangKeyProvider;

@Mod.EventBusSubscriber(modid="ballistix", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(BallistixLootTablesProvider::new, LootContextParamSets.f_81421_))));
            generator.addProvider(true, (DataProvider)new BallistixRecipeProvider(output));
            DatapackBuiltinEntriesProvider datapacks = new DatapackBuiltinEntriesProvider(output, lookupProvider, new RegistrySetBuilder().m_254916_(Registries.f_268580_, BallistixDamageTypes::registerTypes), Set.of("ballistix"));
            generator.addProvider(true, (DataProvider)datapacks);
            BallistixTagsProvider.addTagProviders(generator, output, datapacks.getRegistryProvider(), helper);
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new BallistixBlockStateProvider(output, helper));
            generator.addProvider(true, (DataProvider)new BallistixItemModelsProvider(output, helper));
            generator.addProvider(true, (DataProvider)new BallistixLangKeyProvider(output, BaseLangKeyProvider.Locale.EN_US));
            generator.addProvider(true, (DataProvider)new BallistixSoundProvider(output, helper));
        }
    }
}

