/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.utility;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.utility.TagReference;

public class BnCFluidItemDisplays {
    private static final Map<Fluid, FluidBasedItemStack> FLUID_TYPE_TO_ITEM_MAP = new HashMap<Fluid, FluidBasedItemStack>();
    private static final Codec<ItemStack> SINGLE_ITEM_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("id").forGetter(ItemStack::m_41720_), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(stack -> Optional.ofNullable(stack.m_41783_()))).apply((Applicative)inst, (item, compoundTag) -> {
        ItemStack stack = new ItemStack((ItemLike)item);
        compoundTag.ifPresent(arg_0 -> ((ItemStack)stack).m_41751_(arg_0));
        return stack;
    }));

    public static ItemStack getFluidItemDisplay(RegistryAccess access, FluidStack fluid) {
        if (FLUID_TYPE_TO_ITEM_MAP.containsKey(fluid.getFluid())) {
            return FLUID_TYPE_TO_ITEM_MAP.get(fluid.getFluid()).getStack((RegistryOps<Tag>)RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)access), fluid);
        }
        if (fluid.getFluid().m_6859_() != Items.f_41852_) {
            return fluid.getFluid().m_6859_().m_7968_();
        }
        return ItemStack.f_41583_;
    }

    public record FluidBasedItemStack(Fluid fluid, Map<List<TagReference>, List<TagReference>> fluidTagKeyToItemTagKey, Tag raw) {
        private static final HashMap<CompoundTag, ItemStack> CACHE = new HashMap(32);

        private static FluidBasedItemStack createFromJson(JsonElement json, Fluid fluid) {
            Tag tag = (Tag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.f_128958_, json);
            return new FluidBasedItemStack(fluid, FluidBasedItemStack.getTagKeys(tag), tag);
        }

        private static Map<List<TagReference>, List<TagReference>> getTagKeys(Tag tag) {
            HashMap<List<Object>, List<TagReference>> map;
            block9: {
                ArrayList<TagReference> fluidKeys;
                block8: {
                    map = new HashMap<List<Object>, List<TagReference>>();
                    fluidKeys = new ArrayList<TagReference>();
                    if (!(tag instanceof CompoundTag)) break block8;
                    CompoundTag compoundTag = (CompoundTag)tag;
                    for (String key : compoundTag.m_128431_()) {
                        Tag tag2 = compoundTag.m_128423_(key);
                        if (tag2 instanceof CompoundTag) {
                            CompoundTag innerTag = (CompoundTag)tag2;
                            fluidKeys.add(TagReference.createObject(key));
                            if (innerTag.m_128425_("brewinandchewin:fluid_tag", 8)) {
                                map.put(fluidKeys, TagReference.createFromString(innerTag.m_128461_("brewinandchewin:fluid_tag")));
                                fluidKeys = new ArrayList();
                                continue;
                            }
                            map.putAll(FluidBasedItemStack.getTagKeys((Tag)innerTag));
                        } else {
                            map.putAll(FluidBasedItemStack.getTagKeys(compoundTag.m_128423_(key)));
                        }
                        fluidKeys.clear();
                    }
                    break block9;
                }
                if (!(tag instanceof ListTag)) break block9;
                ListTag listTag = (ListTag)tag;
                for (int i = 0; i < listTag.size(); ++i) {
                    Tag tag3 = listTag.get(i);
                    if (tag3 instanceof CompoundTag) {
                        CompoundTag innerTag = (CompoundTag)tag3;
                        fluidKeys.add(TagReference.createArrayValue(i));
                        if (innerTag.m_128425_("brewinandchewin:fluid_tag", 8)) {
                            map.put(fluidKeys, TagReference.createFromString(innerTag.m_128461_("brewinandchewin:fluid_tag")));
                            fluidKeys = new ArrayList();
                            continue;
                        }
                        map.putAll(FluidBasedItemStack.getTagKeys((Tag)innerTag));
                    } else {
                        map.putAll(FluidBasedItemStack.getTagKeys(listTag.get(i)));
                    }
                    fluidKeys.clear();
                }
            }
            return ImmutableMap.copyOf(map);
        }

        private ItemStack getStack(RegistryOps<Tag> ops, FluidStack stack) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("id", ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid()).toString());
            if (stack.getTag() != null) {
                tag.m_128365_("tag", (Tag)stack.getTag());
            }
            if (CACHE.containsKey(tag)) {
                return CACHE.get(tag);
            }
            Tag tag2 = this.raw();
            if (tag2 instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag2;
                CompoundTag output = compoundTag.m_6426_();
                for (Map.Entry<List<TagReference>, List<TagReference>> entry : this.fluidTagKeyToItemTagKey.entrySet()) {
                    this.encodeTag(entry.getKey(), entry.getValue(), stack, output);
                }
                ItemStack item = (ItemStack)((Pair)SINGLE_ITEM_CODEC.decode(ops, (Object)output).getOrThrow(false, arg_0 -> ((Logger)BrewinAndChewin.LOG).error(arg_0))).getFirst();
                CACHE.put(tag, item);
                return item;
            }
            ItemStack item = (ItemStack)((Pair)ForgeRegistries.ITEMS.getCodec().xmap(ItemStack::new, ItemStack::m_41720_).decode(ops, (Object)this.raw()).getOrThrow(false, arg_0 -> ((Logger)BrewinAndChewin.LOG).error(arg_0))).getFirst();
            CACHE.put(tag, item);
            return item;
        }

        private void encodeTag(List<TagReference> fluidKeys, List<TagReference> itemKeys, FluidStack stack, CompoundTag output) {
            if (!output.m_128441_("tag")) {
                return;
            }
            Tag current = output.m_128423_("tag");
            for (int i = 0; i < itemKeys.size(); ++i) {
                CompoundTag compoundTag;
                TagReference key = itemKeys.get(i);
                if (i == itemKeys.size() - 1) {
                    Tag newElement = this.getTagFromFluidStack(stack, fluidKeys);
                    if (key.isArrayValue()) {
                        if (current instanceof ListTag) {
                            ListTag listTag = (ListTag)current;
                            listTag.set(key.index(), newElement);
                            break;
                        }
                        throw new RuntimeException("Unable to map tag " + String.join((CharSequence)".", itemKeys.stream().map(TagReference::key).toList()) + ". Tag " + String.join((CharSequence)".", itemKeys.stream().map(TagReference::key).toList()) + " is not a list tag.");
                    }
                    if (current instanceof CompoundTag) {
                        compoundTag = (CompoundTag)current;
                        compoundTag.m_128365_(key.key(), newElement);
                        break;
                    }
                    throw new RuntimeException("Unable to map tag " + String.join((CharSequence)".", itemKeys.stream().map(TagReference::key).toList()) + ". Tag " + String.join((CharSequence)".", itemKeys.stream().map(TagReference::key).toList()) + " is not a compound tag.");
                }
                if (key.isArrayValue()) {
                    if (current instanceof ListTag) {
                        ListTag listTag = (ListTag)current;
                        if (listTag.size() < key.index()) {
                            current = listTag.get(key.index());
                            continue;
                        }
                        throw new RuntimeException("Unable to find tag " + String.join((CharSequence)".", itemKeys.subList(0, i).stream().map(TagReference::key).toList()) + " in output json.");
                    }
                    throw new RuntimeException("Unable to map tag " + String.join((CharSequence)".", itemKeys.subList(0, i).stream().map(TagReference::key).toList()) + ". Tag " + String.join((CharSequence)".", String.join((CharSequence)".", itemKeys.subList(0, i).stream().map(TagReference::key).toList())) + " is not a list tag.");
                }
                if (current instanceof CompoundTag) {
                    compoundTag = (CompoundTag)current;
                    if (compoundTag.m_128441_(key.key())) {
                        current = compoundTag.m_128423_(key.key());
                        continue;
                    }
                    throw new RuntimeException("Unable to find tag " + String.join((CharSequence)".", itemKeys.subList(0, i).stream().map(TagReference::key).toList()) + " in output json.");
                }
                throw new RuntimeException("Unable to map tag " + String.join((CharSequence)".", itemKeys.subList(0, i).stream().map(TagReference::key).toList()) + ". Tag " + String.join((CharSequence)".", String.join((CharSequence)".", itemKeys.subList(0, i).stream().map(TagReference::key).toList())) + " is not a compound tag.");
            }
        }

        private Tag getTagFromFluidStack(FluidStack stack, List<TagReference> fluidKeys) {
            if (stack.getTag() == null) {
                throw new RuntimeException("Fluid Stack " + String.valueOf(ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid())) + " does not have the specified tag.");
            }
            CompoundTag fluidTag = stack.getTag();
            CompoundTag returnValue = new CompoundTag();
            for (int i = 0; i < fluidKeys.size(); ++i) {
                ListTag listTag;
                TagReference key = fluidKeys.get(i);
                if (i == fluidKeys.size() - 1) {
                    if (key.isArrayValue()) {
                        if (fluidTag instanceof ListTag) {
                            listTag = (ListTag)fluidTag;
                            if (listTag.size() < key.index()) {
                                returnValue = listTag.get(key.index());
                                break;
                            }
                            throw new RuntimeException("Unable to find tag " + String.join((CharSequence)".", fluidKeys.stream().map(TagReference::key).toList()) + " in fluid stack.");
                        }
                        throw new RuntimeException("Unable to map tag " + String.join((CharSequence)".", fluidKeys.stream().map(TagReference::key).toList()) + ". Tag " + String.join((CharSequence)".", fluidKeys.stream().map(TagReference::key).toList()) + " is not a list tag.");
                    }
                    if (fluidTag instanceof CompoundTag) {
                        CompoundTag compoundTag = fluidTag;
                        if (compoundTag.m_128441_(key.key())) {
                            returnValue = compoundTag.m_128423_(key.key());
                            break;
                        }
                        throw new RuntimeException("Unable to find tag " + String.join((CharSequence)".", fluidKeys.stream().map(TagReference::key).toList()) + " in fluid stack.");
                    }
                    throw new RuntimeException("Unable to map tag " + String.join((CharSequence)".", fluidKeys.stream().map(TagReference::key).toList()) + ". Tag " + String.join((CharSequence)".", fluidKeys.stream().map(TagReference::key).toList()) + " is not a compound tag.");
                }
                if (key.isArrayValue()) {
                    if (fluidTag instanceof ListTag) {
                        listTag = (ListTag)fluidTag;
                        if (listTag.size() < key.index()) {
                            fluidTag = listTag.get(key.index());
                            continue;
                        }
                        throw new RuntimeException("Unable to find tag " + String.join((CharSequence)".", fluidKeys.subList(0, i).stream().map(TagReference::key).toList()) + " in fluid stack.");
                    }
                    throw new RuntimeException("Unable to map tag " + String.join((CharSequence)".", fluidKeys.subList(0, i).stream().map(TagReference::key).toList()) + ". Tag " + String.join((CharSequence)".", fluidKeys.subList(0, i).stream().map(TagReference::key).toList()) + " is not a list tag.");
                }
                if (fluidTag instanceof CompoundTag) {
                    CompoundTag compoundTag = fluidTag;
                    if (compoundTag.m_128441_(key.key())) {
                        fluidTag = compoundTag.m_128423_(key.key());
                        continue;
                    }
                    throw new RuntimeException("Unable to find tag " + String.join((CharSequence)".", fluidKeys.subList(0, i).stream().map(TagReference::key).toList()) + " in fluid stack.");
                }
                throw new RuntimeException("Unable to map tag " + String.join((CharSequence)".", fluidKeys.subList(0, i).stream().map(TagReference::key).toList()) + ". Tag " + String.join((CharSequence)".", fluidKeys.subList(0, i).stream().map(TagReference::key).toList()) + " is not a compound tag.");
            }
            return returnValue;
        }
    }

    public static class Loader
    extends SimplePreparableReloadListener<Map<Fluid, FluidBasedItemStack>> {
        public static final Loader INSTANCE = new Loader();
        private static final Gson GSON = new GsonBuilder().create();

        protected Loader() {
        }

        protected Map<Fluid, FluidBasedItemStack> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
            FileToIdConverter fileToIdConverter = FileToIdConverter.m_246568_((String)"brewinandchewin/fluid_item_displays");
            FluidBasedItemStack.CACHE.clear();
            HashMap<Fluid, FluidBasedItemStack> map = new HashMap<Fluid, FluidBasedItemStack>();
            for (Map.Entry entry : fileToIdConverter.m_246760_(resourceManager).entrySet()) {
                for (Resource resource : (List)entry.getValue()) {
                    try {
                        BufferedReader reader = resource.m_215508_();
                        try {
                            JsonObject jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                            for (Map.Entry e : jsonObject.entrySet()) {
                                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation((String)e.getKey()));
                                if (fluid == null) {
                                    if (((JsonElement)e.getValue()).isJsonObject() && ((JsonElement)e.getValue()).getAsJsonObject().has("optional") && ((JsonElement)e.getValue()).getAsJsonObject().get("optional").getAsBoolean()) continue;
                                    BrewinAndChewin.LOG.error("Could not find fluid '{}' from fluid item display JSON at location '{}' from pack '{}'.", new Object[]{e.getKey(), entry.getKey(), resource.m_215506_()});
                                    continue;
                                }
                                map.put(fluid, FluidBasedItemStack.createFromJson((JsonElement)e.getValue(), fluid));
                            }
                        }
                        finally {
                            if (reader == null) continue;
                            ((Reader)reader).close();
                        }
                    }
                    catch (JsonParseException | IOException | IllegalArgumentException ex) {
                        BrewinAndChewin.LOG.error("Couldn't parse fluid item display JSON at location '{}' from pack '{}'. ", new Object[]{entry.getKey(), resource.m_215506_(), ex});
                    }
                }
            }
            return map;
        }

        protected void apply(Map<Fluid, FluidBasedItemStack> obj, ResourceManager resourceManager, ProfilerFiller profiler) {
            FLUID_TYPE_TO_ITEM_MAP.putAll(obj);
        }
    }
}

