/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.emi.widget;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import umpaz.brewinandchewin.client.utility.BnCFluidItemDisplays;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.integration.emi.recipe.FermentingEmiRecipe;

public class BnCFluidWidget
extends SlotWidget {
    private final Function<Random, EmiStack> fluidGenerator = random -> {
        List stacks = fluid.getEmiStacks();
        return (EmiStack)stacks.get(random.nextInt(stacks.size()));
    };
    private final int unique;
    private long lastFluidGenerate = 0L;
    private EmiIngredient fluidIngredient = null;
    private boolean invalidateItemStack = false;
    private EmiIngredient itemIngredient = null;

    public BnCFluidWidget(EmiIngredient fluid, int unique, int x, int y) {
        super((EmiIngredient)EmiStack.EMPTY, x, y);
        this.unique = unique;
        this.custom = true;
        this.customWidth = 28;
        this.customHeight = 32;
        this.output = true;
    }

    public void drawBackground(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        IClientFluidTypeExtensions fluidTypeExtensions;
        ResourceLocation stillTexture;
        Bounds bounds = this.getBounds();
        FluidStack fluidStack = new FluidStack((Fluid)((EmiStack)this.getStack().getEmiStacks().get(0)).getKey(), (int)((EmiStack)this.getStack().getEmiStacks().get(0)).getAmount(), ((EmiStack)this.getStack().getEmiStacks().get(0)).getNbt());
        if (((Boolean)BnCConfiguration.RENDER_FLUID_IN_KEG.get()).booleanValue() && (stillTexture = (fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid())).getStillTexture(fluidStack)) != null) {
            int y2;
            int y1;
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(stillTexture);
            int tintColor = fluidTypeExtensions.getTintColor(fluidStack);
            float alpha = (float)(tintColor >> 24 & 0xFF) / 255.0f;
            float red = (float)(tintColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(tintColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(tintColor & 0xFF) / 255.0f;
            float capacity = (float)Math.min((Integer)BnCConfiguration.KEG_CAPACITY.get(), fluidStack.getAmount()) / (float)((Integer)BnCConfiguration.KEG_CAPACITY.get()).intValue();
            if ((double)capacity > 0.57) {
                y1 = bounds.y() + 2 + (int)(12.0f * (1.0f - (capacity - 0.57f) / 0.43f));
                y2 = bounds.y() + 2 + 12;
                float topCapacity = (capacity - 0.57f) / 0.43f;
                float vDistance = sprite.m_118412_() - sprite.m_118411_();
                float v0 = sprite.m_118411_() + 0.25f * vDistance + 0.75f * vDistance * (1.0f - topCapacity);
                draw.m_280479_(sprite.m_247685_(), bounds.x() + 2, bounds.x() + 2 + 16, y1, y2, 0, sprite.m_118409_(), sprite.m_118410_(), v0, sprite.m_118412_(), red, green, blue, alpha);
                draw.m_280479_(sprite.m_247685_(), bounds.x() + 2 + 16, bounds.x() + 2 + 16 + 8, y1, y2, 0, sprite.m_118409_(), sprite.m_118409_() + 0.5f * (sprite.m_118410_() - sprite.m_118409_()), v0, sprite.m_118412_(), red, green, blue, alpha);
            }
            y1 = bounds.y() + 2 + 12 + (int)(16.0f * (1.0f - Math.min(1.0f, capacity / 0.57f)));
            y2 = bounds.y() + 2 + 12 + 16;
            float vDistance = sprite.m_118412_() - sprite.m_118411_();
            float v0 = sprite.m_118411_() + vDistance * (1.0f - Math.min(1.0f, capacity / 0.57f));
            draw.m_280479_(sprite.m_247685_(), bounds.x() + 2, bounds.x() + 2 + 16, y1, y2, 0, sprite.m_118409_(), sprite.m_118410_(), v0, sprite.m_118412_(), red, green, blue, alpha);
            draw.m_280479_(sprite.m_247685_(), bounds.x() + 2 + 16, bounds.x() + 2 + 16 + 8, y1, y2, 0, sprite.m_118409_(), sprite.m_118409_() + 0.5f * (sprite.m_118410_() - sprite.m_118409_()), v0, sprite.m_118412_(), red, green, blue, alpha);
        }
    }

    public void drawStack(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        Bounds bounds = this.getBounds();
        int xOff = (bounds.width() - 16) / 2;
        int yOff = (bounds.height() - 16) / 2 - 4;
        this.getItemStack().render(draw, bounds.x() + xOff, bounds.y() + yOff, delta);
    }

    public void drawOverlay(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        Bounds bounds = this.getBounds();
        draw.m_280218_(FermentingEmiRecipe.BACKGROUND, bounds.x() + 1, bounds.y() + 1, 170, 45, bounds.width(), bounds.height() - 2);
        super.drawOverlay(draw, mouseX, mouseY, delta);
    }

    public EmiIngredient getStack() {
        long time = System.currentTimeMillis() / 1000L;
        if (this.fluidIngredient == null || time > this.lastFluidGenerate) {
            this.lastFluidGenerate = time;
            this.fluidIngredient = (EmiIngredient)this.fluidGenerator.apply(this.getRandom(time));
            this.invalidateItemStack = true;
        }
        return this.fluidIngredient;
    }

    public EmiIngredient getItemStack() {
        if (this.invalidateItemStack) {
            FluidStack fluidStack = new FluidStack((Fluid)((EmiStack)this.getStack().getEmiStacks().get(0)).getKey(), (int)((EmiStack)this.getStack().getEmiStacks().get(0)).getAmount(), ((EmiStack)this.getStack().getEmiStacks().get(0)).getNbt());
            ItemStack itemDisplay = BnCFluidItemDisplays.getFluidItemDisplay(Minecraft.m_91087_().f_91073_.m_9598_(), fluidStack).m_41777_();
            Optional<KegPouringRecipe> pouringRecipe = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((RecipeType)BnCRecipeTypes.KEG_POURING.get()).stream().sorted(Comparator.comparing(KegPouringRecipe::isStrict)).filter(kegPouringRecipe -> {
                if (kegPouringRecipe.isStrict()) {
                    return ItemStack.m_150942_((ItemStack)itemDisplay, (ItemStack)kegPouringRecipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
                }
                return ItemStack.m_41656_((ItemStack)itemDisplay, (ItemStack)kegPouringRecipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
            }).findFirst();
            int pourCount = pouringRecipe.map(kegPouringRecipe -> (int)(Math.min((long)((Integer)BnCConfiguration.KEG_CAPACITY.get()).intValue(), this.getStack().getAmount()) / (long)kegPouringRecipe.getAmount())).orElse(1);
            itemDisplay.m_41764_(pourCount);
            this.itemIngredient = EmiStack.of((ItemStack)itemDisplay);
        }
        return this.itemIngredient;
    }

    private Random getRandom(long time) {
        return new Random(new Random(time ^ (long)this.unique).nextInt());
    }
}

