/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.client.screen.tile;

import electrodynamics.common.inventory.container.tile.ContainerThermoelectricManipulator;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.common.tile.pipelines.gas.gastransformer.thermoelectricmanipulator.GenericTileThermoelectricManipulator;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.screen.ITexture;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.ScreenComponentGeneric;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.gauges.ScreenComponentFluidGauge;
import voltaic.prefab.screen.component.types.gauges.ScreenComponentGasGauge;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentGasPressure;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentGasTemperature;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentGasHandlerMulti;
import voltaic.prefab.utilities.math.Color;

public class ScreenThermoelectricManipulator
extends GenericScreen<ContainerThermoelectricManipulator> {
    private ScreenComponentEditBox temperature;
    private boolean needsUpdate = true;

    public ScreenThermoelectricManipulator(ContainerThermoelectricManipulator container, Inventory inv, Component titleIn) {
        super((GenericContainer)container, inv, titleIn);
        this.f_97727_ += 30;
        this.f_97731_ += 30;
        this.addComponent((AbstractScreenComponent)new ScreenComponentFluidGauge(() -> {
            GenericTileThermoelectricManipulator boiler = (GenericTileThermoelectricManipulator)container.getSafeHost();
            if (boiler != null) {
                return ((ComponentFluidHandlerMulti)boiler.getComponent(IComponentType.FluidHandler)).getInputTanks()[0];
            }
            return null;
        }, 10, 18));
        this.addComponent((AbstractScreenComponent)new ScreenComponentFluidGauge(() -> {
            GenericTileThermoelectricManipulator boiler = (GenericTileThermoelectricManipulator)container.getSafeHost();
            if (boiler != null) {
                return ((ComponentFluidHandlerMulti)boiler.getComponent(IComponentType.FluidHandler)).getOutputTanks()[0];
            }
            return null;
        }, 96, 18));
        this.addComponent((AbstractScreenComponent)new ScreenComponentGasGauge(() -> {
            GenericTileThermoelectricManipulator boiler = (GenericTileThermoelectricManipulator)container.getSafeHost();
            if (boiler != null) {
                return ((ComponentGasHandlerMulti)boiler.getComponent(IComponentType.GasHandler)).getInputTanks()[0];
            }
            return null;
        }, 46, 18));
        this.addComponent((AbstractScreenComponent)new ScreenComponentGasGauge(() -> {
            GenericTileThermoelectricManipulator boiler = (GenericTileThermoelectricManipulator)container.getSafeHost();
            if (boiler != null) {
                return ((ComponentGasHandlerMulti)boiler.getComponent(IComponentType.GasHandler)).getOutputTanks()[0];
            }
            return null;
        }, 132, 18));
        this.addComponent((AbstractScreenComponent)new ScreenComponentGasTemperature(-25, 54));
        this.addComponent((AbstractScreenComponent)new ScreenComponentGasPressure(-25, 28));
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(-25, 2));
        this.addComponent((AbstractScreenComponent)new ScreenComponentGeneric((ITexture)ITexture.Textures.CONDENSER_COLUMN, 62, 19));
        this.temperature = new ScreenComponentEditBox(94, 75, 59, 16, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(20).setResponder(this::setTemperature).setFilter(ScreenComponentEditBox.POSITIVE_INTEGER);
        this.addEditBox(this.temperature);
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(10, 80, 10, Color.TEXT_GRAY, (Component)ElectroTextUtils.gui("thermoelectricmanipulator.temp", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(155, 80, 10, Color.TEXT_GRAY, DisplayUnits.TEMPERATURE_KELVIN.getSymbol()));
    }

    private void setTemperature(String temp) {
        GenericTileThermoelectricManipulator manipulator = (GenericTileThermoelectricManipulator)((ContainerThermoelectricManipulator)this.f_97732_).getSafeHost();
        if (manipulator == null) {
            return;
        }
        if (temp.isEmpty()) {
            return;
        }
        int temperature = 293;
        try {
            temperature = Integer.parseInt(temp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (temperature < 1) {
            temperature = 293;
        } else if (temperature > ElectroConstants.GAS_TRANSFORMER_OUTPUT_TEMP_CAP) {
            temperature = ElectroConstants.GAS_TRANSFORMER_OUTPUT_TEMP_CAP;
            this.temperature.setValue("" + temperature);
        }
        manipulator.targetTemperature.setValue((Object)temperature);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.needsUpdate) {
            this.needsUpdate = false;
            GenericTileThermoelectricManipulator manipulator = (GenericTileThermoelectricManipulator)((ContainerThermoelectricManipulator)this.f_97732_).getSafeHost();
            if (manipulator != null) {
                this.temperature.setValue("" + manipulator.targetTemperature.getValue());
            }
        }
    }
}

