/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.blockitem;

import electrodynamics.common.block.connect.BlockWire;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import java.util.HashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.common.blockitem.BlockItemDescriptable;
import voltaic.prefab.utilities.math.Color;

public class BlockItemWire
extends BlockItemDescriptable {
    private static HashSet<BlockItemWire> WIRES = new HashSet();
    private final BlockWire wire;

    public BlockItemWire(BlockWire wire, Item.Properties builder, RegistryObject<CreativeModeTab> creativeTab) {
        super((Block)wire, builder, creativeTab);
        this.wire = wire;
        WIRES.add(this);
    }

    public void m_7373_(ItemStack stack, Level context, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, context, tooltip, flagIn);
        tooltip.add((Component)ElectroTextUtils.tooltip("itemwire.resistance", ChatFormatter.getChatDisplayShort((double)this.wire.wire.getResistance(), (IDisplayUnit)DisplayUnits.RESISTANCE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)ElectroTextUtils.tooltip("itemwire.maxamps", ChatFormatter.getChatDisplayShort((double)this.wire.wire.getAmpacity(), (IDisplayUnit)DisplayUnits.AMPERE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        if (this.wire.wire.getInsulation().shockVoltage() == 0) {
            tooltip.add((Component)ElectroTextUtils.tooltip("itemwire.info.uninsulated", new Object[0]).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)ElectroTextUtils.tooltip("itemwire.info.insulationrating", ChatFormatter.getChatDisplayShort((double)this.wire.wire.getInsulation().shockVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (this.wire.wire.getInsulation().fireproof()) {
            ElectroTextUtils.tooltip("itemwire.info.fireproof", new Object[0]).m_130940_(ChatFormatting.GRAY);
        }
        if (this.wire.wire.getWireClass().conductsRedstone()) {
            ElectroTextUtils.tooltip("itemwire.info.redstone", new Object[0]).m_130940_(ChatFormatting.GRAY);
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="electrodynamics", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class ColorHandler {
        private ColorHandler() {
        }

        @SubscribeEvent
        public static void registerColoredBlocks(RegisterColorHandlersEvent.Item event) {
            WIRES.forEach(item -> event.register((stack, index) -> {
                if (index == 1) {
                    return item.wire.wire.getWireColor().getColor().color();
                }
                return Color.WHITE.color();
            }, new ItemLike[]{item}));
        }
    }
}

