/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.item.gear.tools.electric;

import electrodynamics.common.entity.projectile.types.EntityMetalRod;
import electrodynamics.common.item.gear.tools.electric.utils.ItemRailgun;
import electrodynamics.registers.ElectrodynamicsItems;
import electrodynamics.registers.ElectrodynamicsSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import voltaic.api.item.IItemTemperate;
import voltaic.common.tags.VoltaicTags;
import voltaic.prefab.item.ElectricItemProperties;

public class ItemRailgunKinetic
extends ItemRailgun {
    public static final double JOULES_PER_SHOT = 100000.0;
    public static final int OVERHEAT_TEMPERATURE = 400;
    public static final int TEMPERATURE_PER_SHOT = 300;
    public static final double TEMPERATURE_REDUCED_PER_TICK = 2.0;
    public static final double OVERHEAT_WARNING_THRESHOLD = 0.75;

    public ItemRailgunKinetic(ElectricItemProperties properties, Supplier<CreativeModeTab> creativeTab) {
        super(properties, creativeTab, 400.0, 0.75, 2.0, item -> (Item)ElectrodynamicsItems.ITEM_LITHIUMBATTERY.get());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack ammoStack;
        ItemStack gunStack;
        if (hand == InteractionHand.MAIN_HAND) {
            gunStack = player.m_21205_();
            ammoStack = player.m_21206_();
        } else {
            gunStack = player.m_21206_();
            ammoStack = player.m_21205_();
        }
        if (world.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)gunStack);
        }
        ItemRailgunKinetic railgun = (ItemRailgunKinetic)gunStack.m_41720_();
        if (railgun.getJoulesStored(gunStack) < 100000.0 || ammoStack.m_41619_() || IItemTemperate.getTemperature((ItemStack)gunStack) > 100.0) {
            world.m_5594_(null, player.m_20183_(), (SoundEvent)ElectrodynamicsSounds.SOUND_RAILGUNKINETIC_NOAMMO.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResultHolder.m_19098_((Object)gunStack);
        }
        EntityMetalRod projectile = null;
        int i = 0;
        for (Ingredient ammo : this.getRailgunAmmo()) {
            if (ammo.test(ammoStack)) {
                projectile = new EntityMetalRod((LivingEntity)player, world, i);
                break;
            }
            ++i;
        }
        if (projectile == null) {
            world.m_5594_(null, player.m_20183_(), (SoundEvent)ElectrodynamicsSounds.SOUND_RAILGUNKINETIC_NOAMMO.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResultHolder.m_19098_((Object)gunStack);
        }
        railgun.extractPower(gunStack, 100000.0, false);
        world.m_5594_(null, player.m_20183_(), (SoundEvent)ElectrodynamicsSounds.SOUND_RAILGUNKINETIC.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        projectile.m_37446_(ammoStack);
        projectile.m_20242_(true);
        projectile.m_5602_((Entity)player);
        Vec3 vec31 = player.m_20289_(1.0f);
        Quaternionf quaternionf = new Quaternionf().setAngleAxis(0.0, vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
        Vec3 playerViewVector = player.m_20252_(1.0f);
        Vector3f viewVector = playerViewVector.m_252839_().rotate((Quaternionfc)quaternionf);
        projectile.m_6686_(viewVector.x(), viewVector.y(), viewVector.z(), 20.0f, 0.0f);
        world.m_7967_((Entity)projectile);
        railgun.recieveHeat(gunStack, 300.0, false);
        if (!player.m_7500_()) {
            ammoStack.m_41774_(1);
        }
        return InteractionResultHolder.m_19098_((Object)gunStack);
    }

    public List<Ingredient> getRailgunAmmo() {
        ArrayList<Ingredient> railgunAmmo = new ArrayList<Ingredient>();
        railgunAmmo.add(Ingredient.m_204132_((TagKey)VoltaicTags.Items.ROD_STEEL));
        railgunAmmo.add(Ingredient.m_204132_((TagKey)VoltaicTags.Items.ROD_STAINLESSSTEEL));
        railgunAmmo.add(Ingredient.m_204132_((TagKey)VoltaicTags.Items.ROD_HSLASTEEL));
        return railgunAmmo;
    }
}

