/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.item.gear.tools.electric;

import electrodynamics.common.entity.projectile.types.EntityEnergyBlast;
import electrodynamics.common.item.gear.tools.electric.utils.ItemRailgun;
import electrodynamics.registers.ElectrodynamicsItems;
import electrodynamics.registers.ElectrodynamicsSounds;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import voltaic.api.item.IItemTemperate;
import voltaic.prefab.item.ElectricItemProperties;

public class ItemRailgunPlasma
extends ItemRailgun {
    public static final double JOULES_PER_SHOT = 250000.0;
    private static final int OVERHEAT_TEMPERATURE = 1250;
    private static final int TEMPERATURE_PER_SHOT = 300;
    private static final double TEMPERATURE_REDUCED_PER_TICK = 2.5;
    private static final double OVERHEAT_WARNING_THRESHOLD = 0.5;

    public ItemRailgunPlasma(ElectricItemProperties properties, Supplier<CreativeModeTab> creativeTab) {
        super(properties, creativeTab, 1250.0, 0.5, 2.5, item -> (Item)ElectrodynamicsItems.ITEM_CARBYNEBATTERY.get());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack gunStack = handIn == InteractionHand.MAIN_HAND ? playerIn.m_21205_() : playerIn.m_21206_();
        if (worldIn.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)gunStack);
        }
        ItemRailgunPlasma railgun = (ItemRailgunPlasma)gunStack.m_41720_();
        if (railgun.getJoulesStored(gunStack) < 250000.0 || IItemTemperate.getTemperature((ItemStack)gunStack) > 950.0) {
            worldIn.m_5594_(null, playerIn.m_20183_(), (SoundEvent)ElectrodynamicsSounds.SOUND_RAILGUNKINETIC_NOAMMO.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResultHolder.m_19098_((Object)gunStack);
        }
        EntityEnergyBlast projectile = new EntityEnergyBlast((LivingEntity)playerIn, worldIn);
        projectile.m_20242_(true);
        projectile.m_5602_((Entity)playerIn);
        ItemRailgunPlasma.shootNoY((Projectile)projectile, (Entity)playerIn, playerIn.m_146909_(), playerIn.m_146908_(), 0.0f, 5.0f, 1.0f);
        worldIn.m_7967_((Entity)projectile);
        railgun.extractPower(gunStack, 250000.0, false);
        worldIn.m_5594_(null, playerIn.m_20183_(), (SoundEvent)ElectrodynamicsSounds.SOUND_RAILGUNPLASMA_FIRE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        railgun.recieveHeat(gunStack, 300.0, false);
        return InteractionResultHolder.m_19098_((Object)gunStack);
    }

    private static void shootNoY(Projectile projectile, Entity shooter, float xRot, float yRot, float zRot, float velocity, float inaccuracy) {
        float velX = -Mth.m_14031_((float)(yRot * ((float)Math.PI / 180))) * Mth.m_14089_((float)(xRot * ((float)Math.PI / 180)));
        float velY = -Mth.m_14031_((float)((xRot + zRot) * ((float)Math.PI / 180)));
        float velZ = Mth.m_14089_((float)(yRot * ((float)Math.PI / 180))) * Mth.m_14089_((float)(xRot * ((float)Math.PI / 180)));
        projectile.m_6686_((double)velX, (double)velY, (double)velZ, velocity, inaccuracy);
        Vec3 deltaMove = shooter.m_20184_();
        projectile.m_20256_(projectile.m_20184_().m_82520_(deltaMove.f_82479_, 0.0, deltaMove.f_82481_));
    }
}

