/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.electricitygrid.batteries;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerBatteryBox;
import electrodynamics.prefab.utilities.ElectricityUtils;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import voltaic.common.item.ItemUpgrade;
import voltaic.common.item.subtype.SubtypeItemUpgrade;
import voltaic.prefab.item.ItemElectric;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TransferPack;

public class TileBatteryBox
extends GenericTile
implements IEnergyStorage {
    private final CapabilityUtils.FEInputDispatcher inputDispatcher = new CapabilityUtils.FEInputDispatcher((IEnergyStorage)this);
    private final CapabilityUtils.FEOutputDispatcher outputDispatcher = new CapabilityUtils.FEOutputDispatcher((IEnergyStorage)this);
    public final SingleProperty<Double> powerOutput;
    public final SingleProperty<Double> maxJoules;
    public SingleProperty<Double> currentCapacityMultiplier = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "currentCapacityMultiplier", (Object)1.0));
    public SingleProperty<Double> currentVoltageMultiplier = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "currentVoltageMultiplier", (Object)1.0));
    protected SingleProperty<Double> receiveLimitLeft;
    protected CachedTileOutput output;
    public final int baseVoltage;
    public static final BlockEntityUtils.MachineDirection OUTPUT = BlockEntityUtils.MachineDirection.BACK;
    public static final BlockEntityUtils.MachineDirection INPUT = BlockEntityUtils.MachineDirection.FRONT;

    public TileBatteryBox(BlockPos worldPosition, BlockState blockState) {
        this((BlockEntityType)ElectrodynamicsTiles.TILE_BATTERYBOX.get(), SubtypeMachine.batterybox, 120, 2154.0, 1.0E7, worldPosition, blockState);
    }

    public TileBatteryBox(BlockEntityType<?> type, SubtypeMachine machine, int baseVoltage, double output, double max, BlockPos worldPosition, BlockState blockState) {
        super(type, worldPosition, blockState);
        this.baseVoltage = baseVoltage;
        this.powerOutput = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "powerOutput", (Object)output));
        this.maxJoules = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "maxJoulesStored", (Object)max));
        this.receiveLimitLeft = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "receiveLimitLeft", (Object)(output * (Double)this.currentCapacityMultiplier.getValue())));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(1).upgrades(3)).validUpgrades(ContainerBatteryBox.VALID_UPGRADES).valid((i, s, c) -> i == 0 ? s.m_41720_() instanceof ItemElectric : TileBatteryBox.machineValidator().test(i, s, c)));
        this.addComponent((IComponent)new ComponentContainerProvider(machine.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerBatteryBox((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, true, true).voltage((double)baseVoltage).maxJoules(max).setInputDirections(new BlockEntityUtils.MachineDirection[]{INPUT}).setOutputDirections(new BlockEntityUtils.MachineDirection[]{OUTPUT}));
    }

    protected void tickServer(ComponentTickable tickable) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        Direction facing = this.getFacing();
        if (this.output == null) {
            this.output = new CachedTileOutput(this.f_58857_, this.f_58858_.m_121945_(facing.m_122424_()));
        }
        if (tickable.getTicks() % 40L == 0L) {
            this.output.update(this.f_58858_.m_121945_(facing.m_122424_()));
        }
        if (electro.getJoulesStored() > 0.0 && this.output.valid()) {
            electro.joules(electro.getJoulesStored() - ElectricityUtils.receivePower((BlockEntity)this.output.getSafe(), facing, TransferPack.joulesVoltage((double)Math.min(electro.getJoulesStored(), (Double)this.powerOutput.getValue() * (Double)this.currentCapacityMultiplier.getValue()), (double)electro.getVoltage()), false).getJoules());
        }
        if (electro.getJoulesStored() > electro.getMaxJoulesStored()) {
            electro.joules(electro.getMaxJoulesStored());
        }
        electro.drainElectricItem(0);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY && side != null) {
            Direction facing = this.getFacing();
            if (side == facing) {
                return LazyOptional.of(() -> this.inputDispatcher).cast();
            }
            if (side == facing.m_122424_()) {
                return LazyOptional.of(() -> this.outputDispatcher).cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        int receive = (int)Math.min((double)maxReceive, (Double)this.powerOutput.getValue() * (Double)this.currentCapacityMultiplier.getValue());
        int accepted = Math.min(receive, (int)(electro.getMaxJoulesStored() - electro.getJoulesStored()));
        if (!simulate) {
            electro.joules(electro.getJoulesStored() + (double)accepted);
        }
        return accepted;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        int extract = (int)Math.min((double)maxExtract, (Double)this.powerOutput.getValue() * (Double)this.currentCapacityMultiplier.getValue());
        int taken = Math.min(extract, (int)electro.getJoulesStored());
        if (!simulate) {
            electro.joules(electro.getJoulesStored() - (double)taken);
            if (electro.getVoltage() > 120.0) {
                electro.overVoltage(TransferPack.joulesVoltage((double)taken, (double)electro.getVoltage()));
            }
        }
        return taken;
    }

    public int getEnergyStored() {
        return (int)Math.min(2.147483647E9, ((ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic)).getJoulesStored());
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(2.147483647E9, ((ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic)).getMaxJoulesStored());
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public void onInventoryChange(ComponentInventory inv, int slot) {
        super.onInventoryChange(inv, slot);
        if (inv.getUpgradeContents().size() > 0 && (slot >= inv.getUpgradeSlotStartIndex() || slot == -1)) {
            ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
            double capacityMultiplier = 1.0;
            double voltageMultiplier = 1.0;
            for (ItemStack stack : inv.getUpgradeContents()) {
                Item item;
                if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ItemUpgrade)) continue;
                ItemUpgrade upgrade = (ItemUpgrade)item;
                if (!upgrade.subtype.isEmpty) continue;
                for (int i = 0; i < stack.m_41613_(); ++i) {
                    if (upgrade.subtype == SubtypeItemUpgrade.basiccapacity) {
                        capacityMultiplier = Math.min(capacityMultiplier * 1.5, Math.pow(1.5, 3.0));
                        voltageMultiplier = Math.min(voltageMultiplier * 2.0, 2.0);
                        continue;
                    }
                    if (upgrade.subtype != SubtypeItemUpgrade.advancedcapacity) continue;
                    capacityMultiplier = Math.min(capacityMultiplier * 2.25, Math.pow(2.25, 3.0));
                    voltageMultiplier = Math.min(voltageMultiplier * 4.0, 4.0);
                }
            }
            this.currentCapacityMultiplier.setValue((Object)capacityMultiplier);
            this.currentVoltageMultiplier.setValue((Object)voltageMultiplier);
            this.receiveLimitLeft.setValue((Object)((Double)this.powerOutput.getValue() * (Double)this.currentCapacityMultiplier.getValue()));
            electro.maxJoules((Double)this.maxJoules.getValue() * (Double)this.currentCapacityMultiplier.getValue());
            electro.voltage((double)this.baseVoltage * (Double)this.currentVoltageMultiplier.getValue());
        }
    }

    public int getComparatorSignal() {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        return (int)(electro.getJoulesStored() / Math.max(1.0, electro.getMaxJoulesStored()) * 15.0);
    }
}

