/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.electricitygrid.transformer;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerAdvancedDowngradeTransformer;
import electrodynamics.common.inventory.container.tile.ContainerAdvancedUpgradeTransformer;
import electrodynamics.common.tile.electricitygrid.transformer.TileGenericTransformer;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;

public abstract class TileAdvancedTransformer
extends TileGenericTransformer {
    public final SingleProperty<Double> coilRatio;
    public final double defaultCoilRatio;

    public TileAdvancedTransformer(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState, double defaultCoilRatio) {
        super(type, worldPosition, blockState);
        this.coilRatio = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "coilratio", (Object)defaultCoilRatio));
        this.defaultCoilRatio = defaultCoilRatio;
    }

    @Override
    public void onEntityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
    }

    @Override
    public double getCoilRatio() {
        return (Double)this.coilRatio.getValue() <= 0.0 ? this.defaultCoilRatio : (Double)this.coilRatio.getValue();
    }

    public static final class TileAdvancedUpgradeTransformer
    extends TileAdvancedTransformer {
        public TileAdvancedUpgradeTransformer(BlockPos worldPosition, BlockState blockState) {
            super((BlockEntityType)ElectrodynamicsTiles.TILE_ADVANCEDUPGRADETRANSFORMER.get(), worldPosition, blockState, 2.0);
            this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.advancedupgradetransformer.tag(), (GenericTile)this).createMenu((id, playerinv) -> new ContainerAdvancedUpgradeTransformer((int)id, (Inventory)playerinv, (ContainerData)this.getCoordsArray())));
        }
    }

    public static final class TileAdvancedDowngradeTransformer
    extends TileAdvancedTransformer {
        public TileAdvancedDowngradeTransformer(BlockPos worldPosition, BlockState blockState) {
            super((BlockEntityType)ElectrodynamicsTiles.TILE_ADVANCEDDOWNGRADETRANSFORMER.get(), worldPosition, blockState, 0.5);
            this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.advanceddowngradetransformer.tag(), (GenericTile)this).createMenu((id, playerinv) -> new ContainerAdvancedDowngradeTransformer((int)id, (Inventory)playerinv, (ContainerData)this.getCoordsArray())));
        }
    }
}

