/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.machines;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.registers.ElectrodynamicsRecipies;
import electrodynamics.registers.ElectrodynamicsSounds;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.Voltaic;
import voltaic.common.inventory.container.ContainerDO2OProcessor;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileOxidationFurnace
extends GenericTile
implements ITickableSound {
    private boolean isSoundPlaying = false;

    public TileOxidationFurnace(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_OXIDATIONFURNACE.get(), worldPosition, blockState);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}).voltage(240.0));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().processors(1, 2, 1, 1).upgrades(3)).setSlotsByDirection(BlockEntityUtils.MachineDirection.TOP, new Integer[]{0}).setSlotsByDirection(BlockEntityUtils.MachineDirection.RIGHT, new Integer[]{1}).setDirectionsBySlot(Integer.valueOf(2), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.LEFT}).setDirectionsBySlot(Integer.valueOf(3), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.LEFT}).validUpgrades(ContainerDO2OProcessor.VALID_UPGRADES).valid(TileOxidationFurnace.machineValidator()));
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.oxidationfurnace.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerDO2OProcessor(id.intValue(), player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
        this.addComponent((IComponent)new ComponentProcessor((GenericTile)this).canProcess(this::canProcessOxideFurn).process(ComponentProcessor::processItem2ItemRecipe));
    }

    protected boolean canProcessOxideFurn(ComponentProcessor component, int procNumber) {
        boolean canProcess = component.canProcessItem2ItemRecipe(procNumber, (RecipeType)ElectrodynamicsRecipies.OXIDATION_FURNACE_TYPE.get());
        if (BlockEntityUtils.isLit((GenericTile)this) ^ canProcess) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)canProcess);
        }
        return canProcess;
    }

    protected void tickClient(ComponentTickable tickable) {
        if (!this.shouldPlaySound()) {
            return;
        }
        if (this.f_58857_.f_46441_.m_188500_() < 0.5) {
            double xShift;
            Direction direction = this.getFacing();
            int next = this.f_58857_.f_46441_.m_216332_(0, 2);
            double yShift = Voltaic.RANDOM.nextDouble(0.2) + 0.5;
            double axisShift = Voltaic.RANDOM.nextDouble(0.7) + 0.18;
            if (next == 1) {
                direction = direction.m_122427_();
                yShift = 0.6;
            } else if (next == 2) {
                direction = direction.m_122428_();
                yShift = 0.6;
            }
            double d = direction.m_122434_() == Direction.Axis.X ? (double)(direction.m_122429_() * (direction.m_122429_() == -1 ? 0 : 1)) : (xShift = axisShift);
            double zShift = direction.m_122434_() == Direction.Axis.Z ? (double)(direction.m_122431_() * (direction.m_122431_() == -1 ? 0 : 1)) : axisShift;
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + xShift, (double)this.f_58858_.m_123342_() + yShift, (double)this.f_58858_.m_123343_() + zShift, 0.0, 0.0, 0.0);
        }
        if (!this.isSoundPlaying) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)ElectrodynamicsSounds.SOUND_HUM.get()), (BlockEntity)this, (boolean)true);
        }
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0);
    }

    public int getComparatorSignal() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0) ? 15 : 0;
    }
}

