/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.fluid;

import com.google.common.collect.Lists;
import electrodynamics.common.network.type.FluidNetwork;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import voltaic.api.network.cable.type.IFluidPipe;
import voltaic.prefab.tile.types.GenericRefreshingConnectTile;

public abstract class GenericTileFluidPipe
extends GenericRefreshingConnectTile<IFluidPipe, GenericTileFluidPipe, FluidNetwork> {
    private final IFluidHandler[] handler = new IFluidHandler[6];

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side != null) {
            return LazyOptional.of(() -> this.handler[side.ordinal()]).cast();
        }
        return LazyOptional.empty();
    }

    protected GenericTileFluidPipe(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        for (final Direction dir : Direction.values()) {
            this.handler[dir.ordinal()] = new IFluidHandler(){

                public int getTanks() {
                    return 1;
                }

                public FluidStack getFluidInTank(int tank) {
                    return new FluidStack((Fluid)Fluids.f_76193_, 0);
                }

                public int getTankCapacity(int tank) {
                    return 0;
                }

                public boolean isFluidValid(int tank, FluidStack stack) {
                    return stack != null;
                }

                public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                    if (action == IFluidHandler.FluidAction.SIMULATE || GenericTileFluidPipe.this.getNetwork() == null || resource.isEmpty()) {
                        return 0;
                    }
                    return ((FluidNetwork)GenericTileFluidPipe.this.getNetwork()).emit(resource, (ArrayList<BlockEntity>)Lists.newArrayList((Object[])new BlockEntity[]{GenericTileFluidPipe.this.f_58857_.m_7702_(new BlockPos((Vec3i)GenericTileFluidPipe.this.f_58858_).m_121945_(dir))}), false).getAmount();
                }

                public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                    return FluidStack.EMPTY;
                }

                public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                    return FluidStack.EMPTY;
                }
            };
        }
    }

    public FluidNetwork createInstance(Set<FluidNetwork> fluidNetworks) {
        return new FluidNetwork(fluidNetworks);
    }

    public FluidNetwork createInstanceConductor(Set<GenericTileFluidPipe> genericTileFluidPipes) {
        return new FluidNetwork((Collection<GenericTileFluidPipe>)genericTileFluidPipes);
    }

    public double getMaxTransfer() {
        return ((IFluidPipe)this.getCableType()).getMaxTransfer();
    }

    public void destroyViolently() {
    }
}

