/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.datagen.server.recipe.types.custom.item2item;

import electrodynamics.common.item.subtype.SubtypeCrystal;
import electrodynamics.common.item.subtype.SubtypeDust;
import electrodynamics.common.item.subtype.SubtypeImpureDust;
import electrodynamics.common.item.subtype.SubtypeOxide;
import electrodynamics.common.item.subtype.SubtypePlate;
import electrodynamics.common.item.subtype.SubtypeRawOre;
import electrodynamics.registers.ElectrodynamicsItems;
import electrodynamics.registers.ElectrodynamicsRecipies;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import voltaic.common.recipe.recipeutils.ProbableItem;
import voltaic.common.tags.VoltaicTags;
import voltaic.datagen.utils.server.recipe.AbstractRecipeGenerator;
import voltaic.datagen.utils.server.recipe.FinishedRecipeBase;
import voltaic.datagen.utils.server.recipe.FinishedRecipeItemOutput;

public class ElectrodynamicsMineralCrusherRecipes
extends AbstractRecipeGenerator {
    public static double MINERALCRUSHER_USAGE_PER_TICK = 450.0;
    public static int MINERALCRUSHER_REQUIRED_TICKS = 200;
    private final String modID;

    public ElectrodynamicsMineralCrusherRecipes(String modID) {
        this.modID = modID;
    }

    public ElectrodynamicsMineralCrusherRecipes() {
        this("electrodynamics");
    }

    public void addRecipes(Consumer<FinishedRecipe> consumer) {
        for (SubtypePlate subtypePlate : SubtypePlate.values()) {
            this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_PLATE.getValue((Object)subtypePlate)), 0.1f, 200, 450.0, "plate_" + subtypePlate.name() + "_from_ingot").addItemTagInput(subtypePlate.sourceIngot, 1).complete(consumer);
        }
        for (Enum enum_ : SubtypeCrystal.values()) {
            if (((SubtypeCrystal)enum_).crushedItem == null || enum_ == SubtypeCrystal.halite) continue;
            this.newRecipe(new ItemStack((ItemLike)((SubtypeCrystal)enum_).crushedItem.get()), 0.0f, 200, 450.0, "imp_dust_" + enum_.name() + "_from_crystal").addItemStackInput(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_CRYSTAL.getValue((Object)enum_))).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_OXIDE.getValue((Object)SubtypeOxide.trisulfur)), 0.05)).complete(consumer);
        }
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.salt), 1), 0.1f, 200, 450.0, "salt_from_halite_crystal").addItemStackInput(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_CRYSTAL.getValue((Object)SubtypeCrystal.halite))).complete(consumer);
        for (Enum enum_ : SubtypeRawOre.values()) {
            if (((SubtypeRawOre)enum_).crushedItem == null) continue;
            if (enum_ == SubtypeRawOre.titanium || enum_ == SubtypeRawOre.chromium) {
                this.newRecipe(new ItemStack((ItemLike)((SubtypeRawOre)enum_).crushedItem.get(), 3), 0.5f, 200, 450.0, "oxide_" + enum_.name() + "_from_raw_ore").addItemTagInput(((SubtypeRawOre)enum_).tag, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_IMPUREDUST.getValue((Object)SubtypeImpureDust.iron)), 0.3)).complete(consumer);
                continue;
            }
            this.newRecipe(new ItemStack((ItemLike)((SubtypeRawOre)enum_).crushedItem.get(), 3), 0.3f, 200, 450.0, "imp_dust_" + enum_.name() + "_from_raw_ore").addItemTagInput(((SubtypeRawOre)enum_).tag, 1).complete(consumer);
        }
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_IMPUREDUST.getValue((Object)SubtypeImpureDust.iron), 3), 0.3f, 200, 450.0, "imp_dust_iron_from_raw_ore").addItemTagInput(Tags.Items.RAW_MATERIALS_IRON, 1).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_IMPUREDUST.getValue((Object)SubtypeImpureDust.gold), 3), 0.3f, 200, 450.0, "imp_dust_gold_from_raw_ore").addItemTagInput(Tags.Items.RAW_MATERIALS_GOLD, 1).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_IMPUREDUST.getValue((Object)SubtypeImpureDust.copper), 3), 0.3f, 200, 450.0, "imp_dust_copper_from_raw_ore").addItemTagInput(Tags.Items.RAW_MATERIALS_COPPER, 1).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_OXIDE.getValue((Object)SubtypeOxide.chromite), 3), 0.3f, 200, 450.0, "oxide_chromite_from_ore").addItemTagInput(VoltaicTags.Items.ORE_CHROMIUM, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_IMPUREDUST.getValue((Object)SubtypeImpureDust.iron)), 0.4)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_IMPUREDUST.getValue((Object)SubtypeImpureDust.copper), 3), 0.3f, 200, 450.0, "imp_dust_copper_from_ore").addItemTagInput(ItemTags.f_144318_, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_IMPUREDUST.getValue((Object)SubtypeImpureDust.gold)), 0.1)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_IMPUREDUST.getValue((Object)SubtypeImpureDust.gold), 3), 0.3f, 200, 450.0, "imp_dust_gold_from_ore").addItemTagInput(ItemTags.f_13152_, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_IMPUREDUST.getValue((Object)SubtypeImpureDust.silver)), 0.2)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_IMPUREDUST.getValue((Object)SubtypeImpureDust.iron), 3), 0.3f, 200, 450.0, "imp_dust_iron_from_ore").addItemTagInput(ItemTags.f_144312_, 1).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_IMPUREDUST.getValue((Object)SubtypeImpureDust.lead), 3), 0.3f, 200, 450.0, "imp_dust_lead_from_ore").addItemTagInput(VoltaicTags.Items.ORE_LEAD, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_IMPUREDUST.getValue((Object)SubtypeImpureDust.silver)), 0.4)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_IMPUREDUST.getValue((Object)SubtypeImpureDust.molybdenum), 3), 0.3f, 200, 450.0, "imp_dust_molybdenum_from_ore").addItemTagInput(VoltaicTags.Items.ORE_MOLYBDENUM, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.sulfur)), 0.3)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_IMPUREDUST.getValue((Object)SubtypeImpureDust.netherite), 3), 0.3f, 200, 450.0, "imp_dust_netherite_from_ore").addItemTagInput(Tags.Items.ORES_NETHERITE_SCRAP, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42413_), 0.3)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_IMPUREDUST.getValue((Object)SubtypeImpureDust.silver), 3), 0.2f, 200, 450.0, "imp_dust_silver_from_ore").addItemTagInput(VoltaicTags.Items.ORE_SILVER, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_IMPUREDUST.getValue((Object)SubtypeImpureDust.gold)), 0.1)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_IMPUREDUST.getValue((Object)SubtypeImpureDust.tin), 3), 0.3f, 200, 450.0, "imp_dust_tin_from_ore").addItemTagInput(VoltaicTags.Items.ORE_TIN, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42692_), 0.3)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_IMPUREDUST.getValue((Object)SubtypeImpureDust.vanadium), 3), 0.3f, 200, 450.0, "imp_dust_vanadium_from_ore").addItemTagInput(VoltaicTags.Items.ORE_VANADIUM, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.lead)), 0.2)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.niter), 4), 0.1f, 200, 450.0, "niter_dust_from_ore").addItemTagInput(VoltaicTags.Items.ORE_SALTPETER, 1).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.sulfur), 4), 0.1f, 200, 450.0, "sulfur_dust_from_ore").addItemTagInput(VoltaicTags.Items.ORE_SULFUR, 1).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_OXIDE.getValue((Object)SubtypeOxide.dititanium), 3), 0.5f, 200, 450.0, "oxide_titanium_from_ore").addItemTagInput(VoltaicTags.Items.ORE_TITANIUM, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_IMPUREDUST.getValue((Object)SubtypeImpureDust.iron)), 0.3)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEM_COMPOSITEPLATING.get(), 1), 1.0f, 200, 450.0, "composite_plate").addItemStackInput(new ItemStack((ItemLike)ElectrodynamicsItems.ITEM_RAWCOMPOSITEPLATING.get())).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.obsidian), 2), 0.1f, 200, 450.0, "dust_obsidian_from_obsidian").addItemTagInput(Tags.Items.OBSIDIAN, 1).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)Items.f_42484_, 1), 0.1f, 200, 450.0, "flint_from_gravel").addItemTagInput(Tags.Items.GRAVEL, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_41830_), 0.2)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.salt), 5), 0.1f, 200, 450.0, "salt_from_halite_ore").addItemTagInput(VoltaicTags.Items.ORE_SALT, 1).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_RAWORE.getValue((Object)SubtypeRawOre.fluorite), 2), 0.1f, 200, 450.0, "fluorite_crystal_from_fluorite_ore").addItemTagInput(VoltaicTags.Items.ORE_FLUORITE, 1).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEM_SHEETPLASTIC.get(), 2), 0.1f, 200, 450.0, "plastic_sheet_from_plastic_fibers").addItemStackInput(new ItemStack((ItemLike)ElectrodynamicsItems.ITEM_PLASTIC_FIBERS.get())).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_OXIDE.getValue((Object)SubtypeOxide.chromiumdisilicide)), 1.0)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)Items.f_42593_, 10), 0.0f, 100, 500.0, "blaze_powder_from_blaze_rod").addItemTagInput(Tags.Items.RODS_BLAZE, 1).complete(consumer);
    }

    public FinishedRecipeItemOutput newRecipe(ItemStack stack, float xp, int ticks, double usagePerTick, String name) {
        return FinishedRecipeItemOutput.of((RecipeSerializer)((RecipeSerializer)ElectrodynamicsRecipies.MINERAL_CRUSHER_SERIALIZER.get()), (ItemStack)stack, (double)xp, (int)ticks, (double)usagePerTick).name(FinishedRecipeBase.RecipeCategory.ITEM_2_ITEM, this.modID, "mineral_crusher/" + name);
    }
}

