/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.conduit.type.energy;

import com.enderio.api.conduit.ColoredRedstoneProvider;
import com.enderio.api.conduit.ConduitGraph;
import com.enderio.api.conduit.ConduitNode;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.ticker.CapabilityAwareConduitTicker;
import com.enderio.conduits.common.conduit.type.energy.EnergyConduitData;
import com.enderio.conduits.common.tag.ConduitTags;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyConduitTicker
extends CapabilityAwareConduitTicker<EnergyConduitData, IEnergyStorage> {
    @Override
    public void tickGraph(ServerLevel level, ConduitType<EnergyConduitData> type, List<ConduitNode<EnergyConduitData>> loadedNodes, ConduitGraph<EnergyConduitData> graph, ColoredRedstoneProvider coloredRedstoneProvider) {
        super.tickGraph(level, type, loadedNodes, graph, coloredRedstoneProvider);
        for (ConduitNode node : loadedNodes) {
            EnergyConduitData energyConduitData = (EnergyConduitData)node.getConduitData();
            IEnergyStorage energy = (IEnergyStorage)energyConduitData.getSelfCap().resolve().orElseThrow();
            if (energy.getEnergyStored() == 0) {
                energyConduitData.setCapacity(500);
                continue;
            }
            int previousStored = energy.getEnergyStored();
            for (ConduitNode otherNode : loadedNodes) {
                for (Direction dir : Direction.values()) {
                    Optional capability;
                    BlockEntity be;
                    if (!otherNode.getIOState(dir).map(ConduitNode.IOState::isInsert).orElse(false).booleanValue() || (be = level.m_7702_(otherNode.getPos().m_121945_(dir))) == null || !(capability = be.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_()).resolve()).isPresent()) continue;
                    IEnergyStorage insert = (IEnergyStorage)capability.get();
                    this.extractEnergy(energy, List.of(insert), 0, i -> {});
                }
            }
            if (energy.getEnergyStored() == 0) {
                if (previousStored == energy.getMaxEnergyStored()) {
                    energyConduitData.setCapacity(Math.min(1000000000, 2 * energyConduitData.getCapacity()));
                    continue;
                }
                if (previousStored >= energyConduitData.getCapacity() / 2) continue;
                energyConduitData.setCapacity(Math.max(500, energyConduitData.getCapacity() / 2));
                continue;
            }
            if (energy.getEnergyStored() <= 0) continue;
            energyConduitData.setCapacity(Math.max(500, energy.getEnergyStored()));
        }
    }

    @Override
    public void tickCapabilityGraph(ServerLevel level, ConduitType<EnergyConduitData> type, List<CapabilityAwareConduitTicker.CapabilityConnection> inserts, List<CapabilityAwareConduitTicker.CapabilityConnection> extracts, ConduitGraph<EnergyConduitData> graph, ColoredRedstoneProvider coloredRedstoneProvider) {
        for (CapabilityAwareConduitTicker.CapabilityConnection extract : extracts) {
            IEnergyStorage extractHandler = (IEnergyStorage)extract.capability;
            EnergyConduitData.EnergySidedData sidedExtractData = ((EnergyConduitData)extract.data).castTo(EnergyConduitData.class).compute(extract.direction);
            this.extractEnergy(extractHandler, inserts.stream().map(con -> (IEnergyStorage)con.capability).toList(), sidedExtractData.rotatingIndex, i -> {
                sidedExtractData.rotatingIndex = i;
            });
        }
    }

    private void extractEnergy(IEnergyStorage extractHandler, List<IEnergyStorage> inserts, int startingIndex, Consumer<Integer> rotationIndexSetter) {
        int availableForExtraction = extractHandler.extractEnergy(Integer.MAX_VALUE, true);
        if (availableForExtraction <= 0) {
            return;
        }
        if (inserts.size() <= startingIndex) {
            startingIndex = 0;
            rotationIndexSetter.accept(0);
        }
        for (int j = startingIndex; j < startingIndex + inserts.size(); ++j) {
            int insertIndex = j % inserts.size();
            IEnergyStorage insert = inserts.get(insertIndex);
            int inserted = insert.receiveEnergy(availableForExtraction, false);
            extractHandler.extractEnergy(inserted, false);
            if (inserted == availableForExtraction) {
                rotationIndexSetter.accept(startingIndex + insertIndex + 1);
                return;
            }
            availableForExtraction -= inserted;
        }
    }

    @Override
    public int getTickRate() {
        return 1;
    }

    @Override
    public Capability<IEnergyStorage> getCapability() {
        return ForgeCapabilities.ENERGY;
    }

    @Override
    public boolean canConnectTo(Level level, BlockPos conduitPos, Direction direction) {
        return super.canConnectTo(level, conduitPos, direction) && !level.m_8055_(conduitPos.m_121945_(direction)).m_204336_(ConduitTags.Blocks.ENERGY_CABLE);
    }
}

