/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.tileentities.matrix;

import appeng.api.crafting.IPatternDetails;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import com.glodblock.github.extendedae.common.EPPItemAndBlock;
import com.glodblock.github.extendedae.common.me.CraftingMatrixThread;
import com.glodblock.github.extendedae.common.me.CraftingThread;
import com.glodblock.github.extendedae.common.me.matrix.ClusterAssemblerMatrix;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixFunction;
import com.glodblock.github.glodium.util.GlodUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TileAssemblerMatrixCrafter
extends TileAssemblerMatrixFunction
implements InternalInventoryHost,
IGridTickable {
    public static final int MAX_THREAD = 8;
    private final CraftingThread[] threads = new CraftingThread[8];
    private final InternalInventory internalInv;
    private short states = 0;

    public TileAssemblerMatrixCrafter(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileAssemblerMatrixCrafter.class, TileAssemblerMatrixCrafter::new, (Block)EPPItemAndBlock.ASSEMBLER_MATRIX_CRAFTER), pos, blockState);
        this.getMainNode().addService(IGridTickable.class, (IGridNodeService)this);
        InternalInventory[] invs = new InternalInventory[8];
        for (int x = 0; x < 8; ++x) {
            int index = x;
            this.threads[x] = new CraftingMatrixThread((AEBaseBlockEntity)this, this::getSrc, signal -> this.changeState(index, signal));
            invs[x] = this.threads[x].getInternalInventory();
        }
        this.internalInv = new CombinedInternalInventory(invs);
    }

    private IActionSource getSrc() {
        return this.cluster.getSrc();
    }

    private void changeState(int index, boolean state) {
        boolean oldState = this.states > 0;
        this.states = state ? (short)(this.states | (short)(1 << index)) : (short)(this.states & (short)(~(1 << index)));
        if (state) {
            if (!oldState) {
                this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
            }
        } else if (oldState && this.states <= 0) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().sleepDevice(node));
        }
    }

    public int usedThread() {
        int cnt = 0;
        for (CraftingThread t : this.threads) {
            if (t.getCurrentPattern() != null) {
                ++cnt;
                continue;
            }
            if (t.getInternalInventory().isEmpty()) continue;
            ++cnt;
        }
        return cnt;
    }

    public boolean pushJob(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        for (CraftingThread thread : this.threads) {
            if (!thread.acceptJob(patternDetails, inputHolder, Direction.DOWN)) continue;
            this.cluster.updateCrafter(this);
            return true;
        }
        return false;
    }

    public void stop() {
        for (CraftingThread thread : this.threads) {
            thread.stop();
        }
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        for (int x = 0; x < 8; ++x) {
            CompoundTag tag = this.threads[x].writeNBT();
            data.m_128365_("#ct" + x, (Tag)tag);
        }
        CompoundTag opt = new CompoundTag();
        for (int x = 0; x < this.internalInv.size(); ++x) {
            ItemStack is = this.internalInv.getStackInSlot(x);
            opt.m_128365_("item" + x, (Tag)is.m_41739_(new CompoundTag()));
        }
        data.m_128365_("inv", (Tag)opt);
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        for (int x = 0; x < 8; ++x) {
            if (!data.m_128441_("#ct" + x)) continue;
            this.threads[x].readNBT(data.m_128469_("#ct" + x));
        }
        CompoundTag opt = data.m_128469_("inv");
        for (int x = 0; x < this.internalInv.size(); ++x) {
            CompoundTag item = opt.m_128469_("item" + x);
            this.internalInv.setItemDirect(x, ItemStack.m_41712_((CompoundTag)item));
        }
    }

    @Override
    public void add(ClusterAssemblerMatrix c) {
        c.addCrafter(this);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        boolean isAwake = false;
        for (CraftingThread t : this.threads) {
            t.recalculatePlan();
            t.updateSleepiness();
            isAwake |= t.isAwake();
        }
        return new TickingRequest(1, 1, !isAwake, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.cluster == null) {
            return TickRateModulation.SLEEP;
        }
        TickRateModulation rate = TickRateModulation.SLEEP;
        for (CraftingThread t : this.threads) {
            TickRateModulation tr;
            if (!t.isAwake() || (tr = t.tick(this.cluster.getSpeedCore(), ticksSinceLastCall)).ordinal() <= rate.ordinal()) continue;
            rate = tr;
        }
        this.cluster.updateCrafter(this);
        return rate;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        for (CraftingThread t : this.threads) {
            if (inv != t.getInternalInventory()) continue;
            t.recalculatePlan();
            break;
        }
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (ItemStack stack : this.internalInv) {
            GenericStack genericStack = GenericStack.unwrapItemStack((ItemStack)stack);
            if (genericStack != null) {
                genericStack.what().addDrops(genericStack.amount(), drops, level, pos);
                continue;
            }
            drops.add(stack);
        }
    }

    public void m_6211_() {
        super.m_6211_();
        this.internalInv.clear();
    }
}

