/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slope;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.ISlopeBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.TriangleDir;
import xfacthd.framedblocks.common.data.skippreds.slope.CornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.HalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.InnerCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.InnerThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.ThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.VerticalHalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.SlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalSlopedStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_SLOPE})
public final class SlopeSkipPredicate
implements SideSkipPredicate {
    public static final SlopeSkipPredicate INSTANCE = new SlopeSkipPredicate();

    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            ISlopeBlock slopeBlock = (ISlopeBlock)state.m_60734_();
            Direction dir = slopeBlock.getFacing(state);
            SlopeType type = slopeBlock.getSlopeType(state);
            return switch (blockType) {
                case BlockType.FRAMED_SLOPE, BlockType.FRAMED_RAIL_SLOPE, BlockType.FRAMED_POWERED_RAIL_SLOPE, BlockType.FRAMED_DETECTOR_RAIL_SLOPE, BlockType.FRAMED_ACTIVATOR_RAIL_SLOPE -> SlopeSkipPredicate.testAgainstSlope(dir, type, adjState, side);
                case BlockType.FRAMED_CORNER_SLOPE -> SlopeSkipPredicate.testAgainstCorner(dir, type, adjState, side);
                case BlockType.FRAMED_INNER_CORNER_SLOPE -> SlopeSkipPredicate.testAgainstInnerCorner(dir, type, adjState, side);
                case BlockType.FRAMED_PRISM_CORNER, BlockType.FRAMED_THREEWAY_CORNER -> SlopeSkipPredicate.testAgainstThreewayCorner(dir, type, adjState, side);
                case BlockType.FRAMED_INNER_PRISM_CORNER, BlockType.FRAMED_INNER_THREEWAY_CORNER -> SlopeSkipPredicate.testAgainstInnerThreewayCorner(dir, type, adjState, side);
                case BlockType.FRAMED_HALF_SLOPE -> SlopeSkipPredicate.testAgainstHalfSlope(dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_SLOPE -> SlopeSkipPredicate.testAgainstVerticalHalfSlope(dir, type, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> SlopeSkipPredicate.testAgainstSlopedStairs(dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> SlopeSkipPredicate.testAgainstVerticalSlopedStairs(dir, type, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE})
    private static boolean testAgainstSlope(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        ISlopeBlock block = (ISlopeBlock)adjState.m_60734_();
        Direction adjDir = block.getFacing(adjState);
        SlopeType adjType = block.getSlopeType(adjState);
        return SlopeSkipPredicate.getTriDir(dir, type, side).isEqualTo(SlopeSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_SLOPE})
    private static boolean testAgainstCorner(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        return SlopeSkipPredicate.getTriDir(dir, type, side).isEqualTo(CornerSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_INNER_CORNER_SLOPE})
    private static boolean testAgainstInnerCorner(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        return SlopeSkipPredicate.getTriDir(dir, type, side).isEqualTo(InnerCornerSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_THREEWAY_CORNER, BlockType.FRAMED_PRISM_CORNER})
    private static boolean testAgainstThreewayCorner(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlopeSkipPredicate.getTriDir(dir, type, side).isEqualTo(ThreewayCornerSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_INNER_THREEWAY_CORNER, BlockType.FRAMED_INNER_PRISM_CORNER})
    private static boolean testAgainstInnerThreewayCorner(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlopeSkipPredicate.getTriDir(dir, type, side).isEqualTo(InnerThreewayCornerSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstHalfSlope(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        if (type == SlopeType.HORIZONTAL) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        return SlopeSkipPredicate.getTriDir(dir, type, side).isEqualTo(HalfSlopeSkipPredicate.getTriDir(adjDir, adjTop, adjRight, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstVerticalHalfSlope(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        if (type != SlopeType.HORIZONTAL) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlopeSkipPredicate.getTriDir(dir, type, side).isEqualTo(VerticalHalfSlopeSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPED_STAIRS})
    private static boolean testAgainstSlopedStairs(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        if (type != SlopeType.HORIZONTAL || !Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlopeSkipPredicate.getTriDir(dir, type, side).isEqualTo(SlopedStairsSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_SLOPED_STAIRS})
    private static boolean testAgainstVerticalSlopedStairs(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        if (type == SlopeType.HORIZONTAL) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return SlopeSkipPredicate.getTriDir(dir, type, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    public static TriangleDir getTriDir(Direction dir, SlopeType type, Direction side) {
        if (type == SlopeType.HORIZONTAL) {
            if (Utils.isY(side)) {
                return TriangleDir.fromDirections(dir, dir.m_122428_());
            }
        } else if (side.m_122434_() == dir.m_122427_().m_122434_()) {
            return TriangleDir.fromDirections(dir, type == SlopeType.TOP ? Direction.UP : Direction.DOWN);
        }
        return TriangleDir.NULL;
    }
}

