/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.builder;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.model.util.ColoredBlockModel;

public class ColoredModelBuilder<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    private final List<ColoredBlockModel.ColorData> colors = new ArrayList<ColoredBlockModel.ColorData>();

    public ColoredModelBuilder(T parent, ExistingFileHelper existingFileHelper) {
        this(Mantle.getResource("colored_block"), parent, existingFileHelper);
    }

    protected ColoredModelBuilder(ResourceLocation loaderId, T parent, ExistingFileHelper existingFileHelper) {
        super(loaderId, parent, existingFileHelper);
    }

    public ColoredModelBuilder<T> colorData(ColoredBlockModel.ColorData data) {
        this.colors.add(data);
        return this;
    }

    public ColoredModelBuilder<T> color(int color) {
        return this.colorData(new ColoredBlockModel.ColorData(color, -1, null));
    }

    public ColoredModelBuilder<T> luminosity(int luminosity) {
        return this.colorData(new ColoredBlockModel.ColorData(-1, luminosity, null));
    }

    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        if (!this.colors.isEmpty()) {
            json.add("colors", ColoredBlockModel.ColorData.LIST_LOADABLE.serialize(this.colors));
        }
        return json;
    }
}

