/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.energy.fluxnetworks;

import mekanism.api.Action;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.common.util.UnitDisplayUtils;
import sonar.fluxnetworks.api.energy.IFNEnergyStorage;

public class FNIntegration
implements IFNEnergyStorage {
    private final IStrictEnergyHandler handler;

    public FNIntegration(IStrictEnergyHandler handler) {
        this.handler = handler;
    }

    public long receiveEnergyL(long maxReceive, boolean simulate) {
        FloatingLong remainder;
        if (maxReceive <= 0L) {
            return 0L;
        }
        Action action = Action.get(!simulate);
        FloatingLong toInsert = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(maxReceive);
        if (action.execute()) {
            FloatingLong simulatedRemainder = this.handler.insertEnergy(toInsert, Action.SIMULATE);
            if (simulatedRemainder.equals(toInsert)) {
                return 0L;
            }
            FloatingLong simulatedInserted = toInsert.subtract(simulatedRemainder);
            if ((toInsert = this.convertToAndBack(simulatedInserted)).isZero()) {
                return 0L;
            }
        }
        if ((remainder = this.handler.insertEnergy(toInsert, action)).equals(toInsert)) {
            return 0L;
        }
        FloatingLong inserted = toInsert.subtract(remainder);
        return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertToAsLong(inserted);
    }

    public long extractEnergyL(long maxExtract, boolean simulate) {
        FloatingLong simulatedExtracted;
        if (maxExtract <= 0L) {
            return 0L;
        }
        Action action = Action.get(!simulate);
        FloatingLong toExtract = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(maxExtract);
        if (action.execute() && (toExtract = this.convertToAndBack(simulatedExtracted = this.handler.extractEnergy(toExtract, Action.SIMULATE))).isZero()) {
            return 0L;
        }
        FloatingLong extracted = this.handler.extractEnergy(toExtract, action);
        return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertToAsLong(extracted);
    }

    private FloatingLong convertToAndBack(FloatingLong value) {
        return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertToAsLong(value));
    }

    public long getEnergyStoredL() {
        long energy = 0L;
        int containers = this.handler.getEnergyContainerCount();
        for (int container = 0; container < containers; ++container) {
            long total = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertToAsLong(this.handler.getEnergy(container));
            if (total > Long.MAX_VALUE - energy) {
                return Long.MAX_VALUE;
            }
            energy += total;
        }
        return energy;
    }

    public long getMaxEnergyStoredL() {
        long maxEnergy = 0L;
        int containers = this.handler.getEnergyContainerCount();
        for (int container = 0; container < containers; ++container) {
            long max = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertToAsLong(this.handler.getMaxEnergy(container));
            if (max > Long.MAX_VALUE - maxEnergy) {
                return Long.MAX_VALUE;
            }
            maxEnergy += max;
        }
        return maxEnergy;
    }

    public boolean canExtract() {
        if (!this.handler.extractEnergy(FloatingLong.ONE, Action.SIMULATE).isZero()) {
            return true;
        }
        int containers = this.handler.getEnergyContainerCount();
        for (int container = 0; container < containers; ++container) {
            if (this.handler.getEnergy(container).isZero()) continue;
            return false;
        }
        return true;
    }

    public boolean canReceive() {
        if (this.handler.insertEnergy(FloatingLong.ONE, Action.SIMULATE).smallerThan(FloatingLong.ONE)) {
            return true;
        }
        int containers = this.handler.getEnergyContainerCount();
        for (int container = 0; container < containers; ++container) {
            if (this.handler.getNeededEnergy(container).isZero()) continue;
            return false;
        }
        return true;
    }
}

