/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.ISouliumSpawnerRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class SouliumSpawnerRecipe
implements ISpecialRecipe,
ISouliumSpawnerRecipe {
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final int inputCount;
    private final WeightedRandomList<WeightedEntry.Wrapper<EntityType<?>>> entityTypes;

    public SouliumSpawnerRecipe(ResourceLocation recipeId, Ingredient input, int inputCount, WeightedRandomList<WeightedEntry.Wrapper<EntityType<?>>> entityTypes) {
        this.recipeId = recipeId;
        this.inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{input});
        this.inputCount = inputCount;
        this.entityTypes = entityTypes;
    }

    public ItemStack assemble(IItemHandler inventory, RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.SOULIUM_SPAWNER.get();
    }

    public RecipeType<? extends ISouliumSpawnerRecipe> m_6671_() {
        return (RecipeType)ModRecipeTypes.SOULIUM_SPAWNER.get();
    }

    public boolean matches(IItemHandler inventory) {
        ItemStack stack = inventory.getStackInSlot(0);
        return ((Ingredient)this.inputs.get(0)).test(stack);
    }

    public boolean m_5818_(Container inv, Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    @Override
    public WeightedRandomList<WeightedEntry.Wrapper<EntityType<?>>> getEntityTypes() {
        return this.entityTypes;
    }

    @Override
    public EntityType<?> getFirstEntityType() {
        return (EntityType)((WeightedEntry.Wrapper)this.entityTypes.m_146338_().get(0)).m_146310_();
    }

    @Override
    public Optional<WeightedEntry.Wrapper<EntityType<?>>> getRandomEntityType(RandomSource random) {
        return this.entityTypes.m_216829_(random);
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    public static class Serializer
    implements RecipeSerializer<SouliumSpawnerRecipe> {
        public SouliumSpawnerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonObject ingredient = GsonHelper.m_13930_((JsonObject)json, (String)"input");
            Ingredient input = Ingredient.m_43917_((JsonElement)ingredient);
            int inputCount = GsonHelper.m_13824_((JsonObject)ingredient, (String)"count", (int)1);
            ArrayList<WeightedEntry.Wrapper> entityTypes = new ArrayList<WeightedEntry.Wrapper>();
            for (JsonElement entityTypeJson : GsonHelper.m_13933_((JsonObject)json, (String)"entities")) {
                ResourceLocation entityTypeID = new ResourceLocation(GsonHelper.m_13906_((JsonObject)entityTypeJson.getAsJsonObject(), (String)"entity"));
                int entityTypeWeight = GsonHelper.m_13824_((JsonObject)entityTypeJson.getAsJsonObject(), (String)"weight", (int)1);
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeID);
                if (entityType != null) {
                    entityTypes.add(WeightedEntry.m_146290_((Object)entityType, (int)entityTypeWeight));
                    continue;
                }
                throw new JsonParseException("Unknown entity type: " + entityTypeID);
            }
            if (entityTypes.isEmpty()) {
                throw new JsonParseException("No entities defined for soulium spawner recipe");
            }
            return new SouliumSpawnerRecipe(recipeId, input, inputCount, WeightedRandomList.m_146328_(entityTypes));
        }

        public SouliumSpawnerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int inputCount = buffer.m_130242_();
            int entityCount = buffer.m_130242_();
            ArrayList<WeightedEntry.Wrapper> entityTypes = new ArrayList<WeightedEntry.Wrapper>();
            for (int i = 0; i < entityCount; ++i) {
                ResourceLocation entityTypeID = buffer.m_130281_();
                int entityTypeWeight = buffer.m_130242_();
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeID);
                if (entityType == null) {
                    throw new JsonParseException("Unknown entity type: " + entityTypeID);
                }
                entityTypes.add(WeightedEntry.m_146290_((Object)entityType, (int)entityTypeWeight));
            }
            return new SouliumSpawnerRecipe(recipeId, input, inputCount, WeightedRandomList.m_146328_(entityTypes));
        }

        public void toNetwork(FriendlyByteBuf buffer, SouliumSpawnerRecipe recipe) {
            ((Ingredient)recipe.inputs.get(0)).m_43923_(buffer);
            buffer.m_130130_(recipe.inputCount);
            buffer.m_130130_(recipe.entityTypes.m_146338_().size());
            for (WeightedEntry.Wrapper entityType : recipe.entityTypes.m_146338_()) {
                ResourceLocation id = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)entityType.m_146310_())));
                buffer.m_130085_(id);
                buffer.m_130130_(entityType.m_142631_().m_146281_());
            }
        }
    }
}

