/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.mysticalagriculture.item.WateringCanItem;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EssenceWateringCanItem
extends WateringCanItem {
    private final ChatFormatting textColor;

    public EssenceWateringCanItem(int range, double chance, ChatFormatting textColor) {
        super(range, chance);
        this.textColor = textColor;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        Player player;
        boolean isActive = NBTHelper.getBoolean((ItemStack)stack, (String)"Active");
        if (selected && isActive && entity instanceof Player) {
            player = (Player)entity;
            BlockHitResult trace = EssenceWateringCanItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (trace.m_6662_() == HitResult.Type.BLOCK) {
                this.doWater(stack, level, player, trace.m_82425_(), trace.m_82434_());
            } else {
                EssenceWateringCanItem.stopPlayingSound((Player)player);
            }
        }
        if (!selected && isActive && entity instanceof Player) {
            player = (Player)entity;
            EssenceWateringCanItem.stopPlayingSound((Player)player);
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return NBTHelper.getBoolean((ItemStack)stack, (String)"Active");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        FluidState fluid;
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult trace = EssenceWateringCanItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (trace.m_6662_() != HitResult.Type.BLOCK) {
            if (NBTHelper.getBoolean((ItemStack)stack, (String)"Water") && player.m_6047_()) {
                NBTHelper.flipBoolean((ItemStack)stack, (String)"Active");
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (NBTHelper.getBoolean((ItemStack)stack, (String)"Water")) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        BlockPos pos = trace.m_82425_();
        Direction direction = trace.m_82434_();
        if (level.m_7966_(player, pos) && player.m_36204_(pos.m_121945_(direction), direction, stack) && (fluid = level.m_6425_(pos)).m_205070_(FluidTags.f_13131_)) {
            NBTHelper.setBoolean((ItemStack)stack, (String)"Water", (boolean)true);
            player.m_5496_(SoundEvents.f_11781_, 1.0f, 1.0f);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        InteractionHand hand = context.m_43724_();
        ItemStack stack = player.m_21120_(hand);
        if (NBTHelper.getBoolean((ItemStack)stack, (String)"Active")) {
            return InteractionResult.PASS;
        }
        return super.m_6225_(context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag advanced) {
        super.m_7373_(stack, level, tooltip, advanced);
        String rangeString = String.valueOf(this.range);
        MutableComponent rangeNumber = Component.m_237113_((String)(rangeString + "x" + rangeString)).m_130940_(this.textColor);
        tooltip.add((Component)ModTooltips.TOOL_AREA.args(new Object[]{rangeNumber}).build());
    }
}

