/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.event;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nuclearscience.NuclearScience;
import nuclearscience.api.capability.CapabilityAntimatterItem;
import nuclearscience.api.quantumtunnel.CapabilityChannelMap;
import nuclearscience.api.quantumtunnel.CapabilityTunnelMap;
import nuclearscience.common.command.CommandWipeAllFrequencies;
import nuclearscience.common.command.CommandWipePublicFrequencies;
import nuclearscience.common.reloadlistener.AtomicAssemblerBlacklistRegister;
import nuclearscience.common.reloadlistener.AtomicAssemblerWhitelistRegister;
import nuclearscience.prefab.utils.NuclearCapabilityUtils;
import nuclearscience.registers.NuclearScienceCapabilities;

@Mod.EventBusSubscriber(modid="nuclearscience", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerEventHandler {
    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)AtomicAssemblerBlacklistRegister.INSTANCE);
        event.addListener((PreparableReloadListener)AtomicAssemblerWhitelistRegister.INSTANCE);
    }

    @SubscribeEvent
    public static void serverStartedHandler(ServerStartedEvent event) {
        AtomicAssemblerBlacklistRegister.INSTANCE.generateTagValues();
        AtomicAssemblerWhitelistRegister.INSTANCE.generateTagValues();
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandWipeAllFrequencies.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        CommandWipePublicFrequencies.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void registerLevelCaps(AttachCapabilitiesEvent<Level> event) {
        Level world = (Level)event.getObject();
        if (world != null && world.m_46472_().equals((Object)Level.f_46428_) && world.getCapability(NuclearScienceCapabilities.CAPABILITY_TUNNELMAP).orElse((Object)NuclearCapabilityUtils.EMPTY_TUNNELMAP) == NuclearCapabilityUtils.EMPTY_TUNNELMAP) {
            event.addCapability(NuclearScience.rl("tunnelmap"), (ICapabilityProvider)new CapabilityTunnelMap());
        }
        if (world != null && world.m_46472_().equals((Object)Level.f_46428_) && world.getCapability(NuclearScienceCapabilities.CAPABILITY_CHANNELMAP).orElse((Object)NuclearCapabilityUtils.EMPTY_CHANNELMAP) == NuclearCapabilityUtils.EMPTY_CHANNELMAP) {
            event.addCapability(NuclearScience.rl("channelmap"), (ICapabilityProvider)new CapabilityChannelMap());
        }
    }

    @SubscribeEvent
    public static void registerEntityCaps(AttachCapabilitiesEvent<Entity> event) {
        ItemEntity item;
        Entity entity = (Entity)event.getObject();
        if (entity instanceof ItemEntity && (item = (ItemEntity)entity).getCapability(NuclearScienceCapabilities.CAPABILITY_ANTIMATTERITEM).orElse((Object)NuclearCapabilityUtils.EMPTY_ANTIMATTERITEM) == NuclearCapabilityUtils.EMPTY_ANTIMATTERITEM) {
            event.addCapability(NuclearScience.rl("antimatteritem"), (ICapabilityProvider)new CapabilityAntimatterItem());
        }
    }
}

