/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.logisticsnetwork;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import nuclearscience.common.inventory.container.ContainerControlRodModule;
import nuclearscience.common.network.ReactorLogisticsNetwork;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileReactorLogisticsCable;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.util.GenericTileInterfaceBound;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.registers.VoltaicItems;

public class TileControlRodModule
extends GenericTileInterfaceBound {
    private Direction relativeBack;
    public final SingleProperty<Integer> insertion = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "insertion", (Object)0));
    public final SingleProperty<Integer> redstoneSignal = ((SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "redstonesignal", (Object)0))).onChange((prop, oldVal) -> {
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || prop.getValue() == oldVal) {
            return;
        }
        double perc = (double)((Integer)prop.getValue()).intValue() / 15.0;
        double tot = perc * 100.0;
        int mult = (int)(tot / 10.0);
        this.insertion.setValue((Object)(mult * 10));
    });

    public TileControlRodModule(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)NuclearScienceTiles.TILE_CONTROLRODMODULE.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentContainerProvider("controlrodmodule", (GenericTile)this).createMenu((id, player) -> new ContainerControlRodModule((int)id, (Inventory)player, (Container)new SimpleContainer(0), (ContainerData)this.getCoordsArray())));
        this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
    }

    @Override
    public boolean checkLinkedPosition(GenericTileInterface inter) {
        return ((BlockPos)inter.controlRodLocation.getValue()).equals((Object)this.m_58899_());
    }

    @Override
    public Direction getCableLocation() {
        return this.relativeBack;
    }

    public void onBlockStateUpdate(BlockState oldState, BlockState newState) {
        super.onBlockStateUpdate(oldState, newState);
        if (!this.f_58857_.m_5776_() && oldState.m_61138_((Property)VoltaicBlockStates.FACING) && newState.m_61138_((Property)VoltaicBlockStates.FACING) && oldState.m_61143_((Property)VoltaicBlockStates.FACING) != newState.m_61143_((Property)VoltaicBlockStates.FACING)) {
            this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("relativeback", this.relativeBack.ordinal());
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.relativeBack = Direction.values()[compound.m_128451_("relativeback")];
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        super.onNeightborChanged(neighbor, blockStateTrigger);
        if (!this.f_58857_.f_46443_) {
            this.redstoneSignal.setValue((Object)this.m_58904_().m_277086_(this.m_58899_()));
        }
    }

    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        if (!this.f_58857_.m_5776_()) {
            if (!this.networkCable.valid() || !(this.networkCable.getSafe() instanceof TileReactorLogisticsCable)) {
                return;
            }
            TileReactorLogisticsCable cable = (TileReactorLogisticsCable)((Object)this.networkCable.getSafe());
            if (cable.m_58901_()) {
                return;
            }
            ReactorLogisticsNetwork network = (ReactorLogisticsNetwork)cable.getNetwork();
            GenericTileInterface inter = network.getInterface((BlockPos)this.interfaceLocation.getValue());
            if (inter == null) {
                return;
            }
            inter.controlRodLocation.setValue((Object)BlockEntityUtils.OUT_OF_REACH);
        }
    }

    @Override
    public GenericTileInterface.InterfaceType[] getValidInterfaces() {
        return CONTROL_RODS;
    }

    public InteractionResult use(Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_21120_(hand).m_150930_((Item)VoltaicItems.ITEM_WRENCH.get()) && this.hasComponent(IComponentType.ContainerProvider)) {
            if (!this.f_58857_.f_46443_) {
                player.m_5893_((MenuProvider)this.getComponent(IComponentType.ContainerProvider));
                player.m_36220_(Stats.f_12966_);
            }
            return InteractionResult.CONSUME;
        }
        if (this.f_58857_.m_5776_()) {
            return InteractionResult.CONSUME;
        }
        if (player.m_6144_()) {
            this.insertion.setValue((Object)((Integer)this.insertion.getValue() - 10));
            if ((Integer)this.insertion.getValue() < 0) {
                this.insertion.setValue((Object)100);
            }
        } else {
            this.insertion.setValue((Object)((Integer)this.insertion.getValue() + 10));
            if ((Integer)this.insertion.getValue() > 100) {
                this.insertion.setValue((Object)0);
            }
        }
        return InteractionResult.CONSUME;
    }

    public int getComparatorSignal() {
        return (int)((double)((Integer)this.insertion.getValue()).intValue() / 100.0 * 15.0);
    }

    @Override
    public void onInterfacePropChange(SingleProperty<BlockPos> prop, BlockPos old) {
        GenericTileInterface inter;
        super.onInterfacePropChange(prop, old);
        boolean oldInval = old.equals((Object)BlockEntityUtils.OUT_OF_REACH);
        boolean newInval = ((BlockPos)prop.getValue()).equals((Object)BlockEntityUtils.OUT_OF_REACH);
        if (oldInval && newInval) {
            return;
        }
        if (this.networkCable == null || !this.networkCable.valid() || !(this.networkCable.getSafe() instanceof TileReactorLogisticsCable)) {
            return;
        }
        TileReactorLogisticsCable cable = (TileReactorLogisticsCable)((Object)this.networkCable.getSafe());
        if (cable.m_58901_()) {
            return;
        }
        ReactorLogisticsNetwork network = (ReactorLogisticsNetwork)cable.getNetwork();
        if (oldInval && !newInval) {
            GenericTileInterface inter2 = network.getInterface((BlockPos)prop.getValue());
            if (inter2 != null) {
                inter2.controlRodLocation.setValue((Object)this.m_58899_());
            }
        } else if (!oldInval && newInval && (inter = network.getInterface(old)) != null) {
            inter.controlRodLocation.setValue((Object)BlockEntityUtils.OUT_OF_REACH);
        }
    }
}

