/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.clickable;

import lehjr.numina.client.gui.clickable.Clickable;
import lehjr.numina.client.gui.clickable.IClickable;
import lehjr.numina.client.gui.geometry.IDrawable;
import lehjr.numina.client.gui.geometry.MusePoint2D;
import lehjr.numina.client.gui.geometry.Rect;
import lehjr.numina.common.math.Color;
import lehjr.numina.common.string.StringUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ClickableLabel
extends Clickable {
    protected IClickable.IPressable onPressed;
    protected IClickable.IReleasable onReleased;
    Color color = Color.WHITE;
    boolean shadowed = true;
    protected Component label;
    protected JustifyMode mode;

    public ClickableLabel(Component label, Rect rect) {
        super(rect);
        this.label = label;
        this.mode = JustifyMode.CENTERED;
    }

    public ClickableLabel(Component label, MusePoint2D ul) {
        this(label, ul, JustifyMode.CENTERED);
    }

    public ClickableLabel(Component label, MusePoint2D ul, JustifyMode mode) {
        super(ul, ul.plus(StringUtils.getStringWidth((FormattedText)label), Math.max(StringUtils.getStringHeight(), 10.0)));
        this.label = label;
        this.mode = mode;
    }

    public ClickableLabel(double left, double top, double width, Component label, JustifyMode mode) {
        super(left, top, left + width, top + Math.max(StringUtils.getStringHeight(), 10.0));
        this.label = label;
        this.mode = mode;
    }

    public ClickableLabel setMode(JustifyMode mode) {
        this.mode = mode;
        return this;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setShadowed(boolean shadowed) {
        this.shadowed = shadowed;
    }

    public void setLabel(Component label) {
        this.label = label;
    }

    @Override
    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(gfx, mouseX, mouseY, partialTick);
        gfx.m_280168_().m_85836_();
        gfx.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        if (this.shadowed) {
            switch (this.mode) {
                case LEFT: {
                    StringUtils.drawLeftAlignedShadowedString(gfx, this.label, this.centerX(), this.centerY(), this.color);
                    break;
                }
                case CENTERED: {
                    StringUtils.drawShadowedStringCentered(gfx, this.label, this.centerX(), this.centerY(), this.color);
                    break;
                }
                case RIGHT: {
                    StringUtils.drawRightAlignedShadowedString(gfx, this.label, this.centerX(), this.centerY(), this.color);
                }
            }
        } else {
            switch (this.mode) {
                case LEFT: {
                    StringUtils.drawLeftAlignedText(gfx, this.label, this.centerX(), this.centerY(), this.color);
                    break;
                }
                case CENTERED: {
                    StringUtils.drawCenteredText(gfx, this.label, this.centerX(), this.centerY(), this.color);
                    break;
                }
                case RIGHT: {
                    StringUtils.drawRightAlignedText(gfx, this.label, this.centerX(), this.centerY(), this.color);
                }
            }
        }
        gfx.m_280168_().m_85849_();
    }

    @Override
    public float getZLevel() {
        return 0.0f;
    }

    @Override
    public IDrawable setZLevel(float zLevel) {
        return null;
    }

    @Override
    public boolean containsPoint(double x, double y) {
        if (this.label == null || this.label.getString().isEmpty()) {
            return false;
        }
        MusePoint2D radius = new MusePoint2D(StringUtils.getStringWidth((FormattedText)this.label) / 2.0 + 2.0, StringUtils.getStringHeight());
        return Math.abs(this.centerX() - x) < radius.x() && Math.abs(this.centerY() - y) < radius.y();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setOnPressed(IClickable.IPressable onPressed) {
        this.onPressed = onPressed;
    }

    @Override
    public void setOnReleased(IClickable.IReleasable onReleased) {
        this.onReleased = onReleased;
    }

    @Override
    public void onReleased() {
        if (this.isVisible && this.isEnabled && this.onReleased != null) {
            this.onReleased.onReleased(this);
        }
    }

    @Override
    public void onPressed() {
        if (this.isVisible && this.isEnabled && this.onPressed != null) {
            this.onPressed.onPressed(this);
        }
    }

    public static enum JustifyMode {
        LEFT,
        CENTERED,
        RIGHT;

    }
}

