/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.geometry;

import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.FloatBuffer;
import lehjr.numina.client.gui.geometry.DrawableRect;
import lehjr.numina.client.gui.geometry.GradientAndArcCalculator;
import lehjr.numina.client.gui.geometry.MusePoint2D;
import lehjr.numina.common.math.Color;
import lehjr.numina.common.math.MathUtils;
import net.minecraft.client.gui.GuiGraphics;

public class Meter
extends DrawableRect {
    Color meterColor;
    double value = 0.0;

    public Meter(Color meterColorIn) {
        super(new MusePoint2D(0.0, 0.0), new MusePoint2D(0.0, 0.0), Color.GREY.withAlpha(0.3f), Color.BLACK.withAlpha(0.8f));
        this.setWidth(32.0);
        this.setHeight(8.0);
        this.setSecondBackgroundColor(Color.WHITE.withAlpha(0.3f));
        this.setShrinkBorder(true);
        this.meterColor = meterColorIn;
    }

    public Meter setMeterColor(Color meterColorIn) {
        this.meterColor = meterColorIn;
        return this;
    }

    void setUL(double x, double y) {
        this.setTop(y);
        this.setLeft(x);
    }

    @Override
    public float getCornerradius() {
        return 0.0f;
    }

    public void draw(GuiGraphics gfx, double x, double y, float zLevel, double valueIn) {
        this.setUL(x, y);
        this.value = MathUtils.clampDouble(valueIn, 0.0, 1.0);
        this.draw(gfx, zLevel);
    }

    FloatBuffer getMeterVertices() {
        float right = (float)(this.left() + (this.width() - 1.0) * this.value);
        return this.getVertices(this.left() + 1.0, this.top() + 1.0, right, this.bottom() - 1.0);
    }

    public void draw(GuiGraphics gfx, float zLevel) {
        this.zLevel = zLevel;
        FloatBuffer backgroundVertices = this.getVertices(0.0);
        FloatBuffer backgroundColors = GradientAndArcCalculator.getColorGradient(this.backgroundColor, this.backgroundColor2, backgroundVertices.limit() * 4);
        this.drawBackground(gfx, backgroundVertices, backgroundColors);
        FloatBuffer meterVertices = this.getMeterVertices();
        this.drawBuffer(gfx, meterVertices, this.meterColor, VertexFormat.Mode.TRIANGLE_FAN);
        if (this.shrinkBorder) {
            backgroundVertices = this.getVertices(1.0);
        } else {
            backgroundVertices.rewind();
        }
        this.drawBorder(gfx, backgroundVertices);
    }
}

