/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.model.helper;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Transformation;
import forge.NuminaObjLoader;
import forge.NuminaObjModel;
import forge.QuadTransformers;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import lehjr.numina.client.model.obj.OBJBakedCompositeModel;
import lehjr.numina.common.base.NuminaLogger;
import lehjr.numina.common.math.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.TransformationHelper;
import org.joml.Vector3f;

public class ModelHelper {
    public static Transformation get(float transformX, float transformY, float transformZ, float angleX, float angleY, float angleZ, float scaleX, float scaleY, float scaleZ) {
        return new Transformation(new Vector3f(transformX / 16.0f, transformY / 16.0f, transformZ / 16.0f), TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(angleX, angleY, angleZ), (boolean)true), new Vector3f(scaleX, scaleY, scaleZ), null);
    }

    public static Transformation get(float transformX, float transformY, float transformZ, float angleX, float angleY, float angleZ, float scale) {
        return ModelHelper.get(transformX, transformY, transformZ, angleX, angleY, angleZ, scale, scale, scale);
    }

    public static Transformation getTransform(@Nullable Vector3f translation, @Nullable Vector3f rotation, @Nullable Vector3f scale) {
        if (translation == null) {
            translation = new Vector3f(0.0f, 0.0f, 0.0f);
        }
        if (rotation == null) {
            rotation = new Vector3f(0.0f, 0.0f, 0.0f);
        }
        if (scale == null) {
            scale = new Vector3f(1.0f, 1.0f, 1.0f);
        }
        return new Transformation(new Vector3f(translation.x() / 16.0f, translation.y() / 16.0f, translation.z() / 16.0f), TransformationHelper.quatFromXYZ((Vector3f)rotation, (boolean)true), scale, null);
    }

    public static Function<ResourceLocation, TextureAtlasSprite> defaultTextureGetter(ResourceLocation location) {
        return Minecraft.m_91087_().m_91258_(location);
    }

    @Nullable
    public static NuminaObjModel getOBJModel(ResourceLocation location, int attempt) {
        NuminaObjModel model;
        try {
            model = NuminaObjLoader.INSTANCE.loadModel(new NuminaObjModel.ModelSettings(location, true, true, true, false, null));
        }
        catch (Exception e) {
            if (attempt < 6) {
                model = ModelHelper.getOBJModel(location, attempt + 1);
                NuminaLogger.logError("Model loading failed on attempt #" + attempt + "  :( " + location.toString());
            }
            model = null;
            NuminaLogger.logError("Failed to load model. " + e);
        }
        NuminaLogger.logDebug("got model");
        return model;
    }

    @Nullable
    public static OBJBakedCompositeModel loadBakedModel(ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        NuminaObjModel model = ModelHelper.getOBJModel(modelLocation, 0);
        if (model != null) {
            // empty if block
        }
        return null;
    }

    public static List<BakedQuad> getColoredQuadsWithGlowAndTransform(List<BakedQuad> quadList, Color color, Transformation transform, boolean glow) {
        if (!quadList.isEmpty()) {
            if (glow) {
                QuadTransformers.settingMaxEmissivity().andThen(QuadTransformers.applyingColor(color.getARGBInt())).andThen(QuadTransformers.applying(transform)).processInPlace(quadList);
            } else {
                QuadTransformers.applyingColor(color.getARGBInt()).andThen(QuadTransformers.applying(transform)).processInPlace(quadList);
            }
        }
        return quadList;
    }

    public static BakedQuad coloredQuadWithGlowAndTransform(Color color, BakedQuad quad, boolean glow, Transformation transform) {
        if (glow) {
            QuadTransformers.settingMaxEmissivity().andThen(QuadTransformers.applyingColor(color.getARGBInt())).andThen(QuadTransformers.applying(transform)).processInPlace(quad);
        } else {
            QuadTransformers.applyingColor(color.getARGBInt()).andThen(QuadTransformers.applying(transform)).processInPlace(quad);
        }
        return quad;
    }

    public static List<BakedQuad> getColoredQuadsWithGlow(List<BakedQuad> quadList, Color color, boolean glow) {
        ImmutableList.Builder builder = ImmutableList.builder();
        quadList.forEach(quad -> {
            if (glow) {
                QuadTransformers.settingMaxEmissivity().andThen(QuadTransformers.applyingColor(color.getARGBInt())).processInPlace(quad);
            } else {
                QuadTransformers.applyingColor(color.getARGBInt()).processInPlace(quad);
            }
            builder.add(quad);
        });
        return builder.build();
    }

    public static List<BakedQuad> getColoredQuads(List<BakedQuad> quadList, Color color) {
        ImmutableList.Builder builder = ImmutableList.builder();
        quadList.forEach(quad -> {
            QuadTransformers.applyingColor(color.getARGBInt()).processInPlace(quad);
            builder.add(quad);
        });
        return builder.build();
    }
}

