/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.model.item.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lehjr.numina.client.model.item.armor.RenderOBJPart;
import lehjr.numina.common.base.NuminaLogger;
import lehjr.numina.common.capabilities.render.modelspec.MorphTarget;
import lehjr.numina.common.capabilities.render.modelspec.ObjPartSpec;
import lehjr.numina.common.math.Color;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HighPolyArmor<T extends LivingEntity>
extends HumanoidModel<T> {
    public CompoundTag renderSpec = null;
    public EquipmentSlot visibleSection = EquipmentSlot.HEAD;
    Map<ModelPart, RenderOBJPart> mpToRp = new HashMap<ModelPart, RenderOBJPart>();
    List<ModelPart> headParts = new ArrayList<ModelPart>();
    List<ModelPart> bodyParts = new ArrayList<ModelPart>();

    public HighPolyArmor(ModelPart root) {
        super(root, RenderType::m_110467_);
        this.init();
    }

    protected Iterable<ModelPart> m_5607_() {
        return this.headParts;
    }

    protected Iterable<ModelPart> m_5608_() {
        return this.bodyParts;
    }

    public RenderOBJPart getPart(MorphTarget target) {
        return this.mpToRp.get(target.apply(this));
    }

    public void renderToBuffer(ObjPartSpec partSpec, CompoundTag tag, PoseStack poseStack, VertexConsumer pBuffer, int packedLight, int packedOverlay, Color color) {
        RenderOBJPart part = this.mpToRp.get(partSpec.getBinding().getTarget().apply(this));
        if (part != null) {
            poseStack.m_85836_();
            part.render(partSpec, tag, poseStack, pBuffer, packedLight, packedOverlay, color);
            poseStack.m_85849_();
        } else {
            NuminaLogger.logError("cannot render null part");
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
    }

    protected ModelPart m_102851_(HumanoidArm pSide) {
        return this.mpToRp.get(super.m_102851_(pSide));
    }

    public ModelPart m_5585_() {
        return this.mpToRp.get(this.f_102808_);
    }

    public <M extends HumanoidModel<T>> void copyPropertiesFrom(M otherModel) {
        if (!this.mpToRp.isEmpty()) {
            this.f_102815_ = otherModel.f_102815_;
            this.f_102816_ = otherModel.f_102816_;
            this.f_102817_ = otherModel.f_102817_;
            this.mpToRp.get(this.f_102808_).m_104315_(otherModel.f_102808_);
            this.mpToRp.get(this.f_102810_).m_104315_(otherModel.f_102810_);
            this.mpToRp.get(this.f_102811_).m_104315_(otherModel.f_102811_);
            this.mpToRp.get(this.f_102812_).m_104315_(otherModel.f_102812_);
            this.mpToRp.get(this.f_102813_).m_104315_(otherModel.f_102813_);
            this.mpToRp.get(this.f_102814_).m_104315_(otherModel.f_102814_);
        }
    }

    public void init() {
        this.clearAndAddChildWithInitialOffsets(this.f_102808_, "head", 0.0f, 25.0f, 0.0f);
        this.clearAndAddChildWithInitialOffsets(this.f_102810_, "body", 0.0f, 24.0f, 0.0f);
        this.clearAndAddChildWithInitialOffsets(this.f_102811_, "right_arm", 5.0f, 24.0f, 0.0f);
        this.clearAndAddChildWithInitialOffsets(this.f_102812_, "left_arm", -5.0f, 24.0f, 0.0f);
        this.clearAndAddChildWithInitialOffsets(this.f_102813_, "right_leg", 1.9f, 12.0f, 0.0f);
        this.clearAndAddChildWithInitialOffsets(this.f_102814_, "left_leg", -1.9f, 12.0f, 0.0f);
    }

    public void clearAndAddChildWithInitialOffsets(ModelPart mp, final String partName, float x, float y, float z) {
        final RenderOBJPart rp = new RenderOBJPart((Model)this, mp);
        rp.m_104227_(x, y, z);
        rp.xOffset = x;
        rp.yOffset = y;
        rp.zOffset = z;
        mp.f_104213_ = new HashMap<String, ModelPart>(){
            {
                this.put("mps_" + partName, rp);
            }
        };
        this.mpToRp.put(mp, rp);
        switch (partName) {
            case "head": {
                this.headParts.add(rp);
                break;
            }
            case "body": 
            case "right_arm": 
            case "left_arm": 
            case "right_leg": 
            case "left_leg": {
                this.bodyParts.add(rp);
                break;
            }
        }
    }
}

