/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.blockentity;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.base.NuminaObjects;
import lehjr.numina.common.capabilities.energy.BlockEnergyStorage;
import lehjr.numina.common.capabilities.energy.BlockEnergyWrapper;
import lehjr.numina.common.config.NuminaSettings;
import lehjr.numina.common.energy.ElectricItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ChargingBaseBlockEntity
extends BlockEntity {
    private final ItemStackHandler itemHandler = this.createHandler();
    private final BlockEnergyStorage energyStorage = this.createEnergy();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<IEnergyStorage> tileEnergy = LazyOptional.of(() -> this.energyStorage);
    private final BlockEnergyWrapper energyWrapperStorage = this.createWrapper();
    private final LazyOptional<IEnergyStorage> energyWrapper = LazyOptional.of(() -> this.energyWrapperStorage);

    public ChargingBaseBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)NuminaObjects.CHARGING_BASE_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    @Nullable
    public List<LivingEntity> getEntities() {
        assert (this.f_58857_ != null);
        return this.f_58857_.m_6443_(LivingEntity.class, new AABB(this.f_58858_), entity -> entity instanceof LivingEntity);
    }

    public void m_7651_() {
        super.m_7651_();
        this.handler.invalidate();
        this.tileEnergy.invalidate();
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        ChargingBaseBlockEntity be = (ChargingBaseBlockEntity)blockEntity;
        if (level.f_46443_) {
            return;
        }
        List entityList = level.m_6443_(LivingEntity.class, new AABB(be.m_58899_()), entity -> entity instanceof LivingEntity);
        for (LivingEntity entity2 : entityList) {
            be.sendOutPower(entity2);
        }
        BlockState newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(be.energyWrapper.map(IEnergyStorage::getEnergyStored).orElse(0) > 0));
        if (state != newState) {
            level.m_7731_(be.m_58899_(), newState, 3);
        }
    }

    private void sendOutPower(LivingEntity entity) {
        this.energyWrapper.ifPresent(wrapper -> {
            int received = (int)ElectricItemUtils.givePlayerEnergy(entity, wrapper.getEnergyStored(), false);
            if (received > 0) {
                wrapper.extractEnergy(received, false);
                this.m_6596_();
            }
        });
    }

    public CompoundTag m_5995_() {
        return this.save(new CompoundTag());
    }

    public void m_142466_(CompoundTag nbt) {
        this.itemHandler.deserializeNBT(nbt.m_128469_("inv"));
        this.energyStorage.deserializeNBT(nbt.m_128423_("energy"));
        super.m_142466_(nbt);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        this.save(pTag);
    }

    public CompoundTag save(CompoundTag nbt) {
        nbt.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128365_("energy", this.energyStorage.serializeNBT());
        return nbt;
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                ChargingBaseBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!stack.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    private BlockEnergyStorage createEnergy() {
        return new BlockEnergyStorage(NuminaSettings.chargingBaseMaxPower(), NuminaSettings.chargingBaseMaxPower()){

            @Override
            public void onValueChanged() {
                ChargingBaseBlockEntity.this.m_6596_();
            }
        };
    }

    private BlockEnergyWrapper createWrapper() {
        return new BlockEnergyWrapper(this.tileEnergy, this.handler);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyWrapper.cast();
        }
        return super.getCapability(cap, side);
    }

    public LazyOptional<IEnergyStorage> getBatteryEnergyHandler() {
        return this.handler.map(iItemHandler -> iItemHandler.getStackInSlot(0).getCapability(ForgeCapabilities.ENERGY)).orElse(LazyOptional.empty());
    }

    public LazyOptional<IEnergyStorage> getBlockEnergyHandler() {
        return this.tileEnergy;
    }
}

