/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.player.keystates;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.capabilities.NuminaCapabilities;
import lehjr.numina.common.capabilities.player.keystates.IPlayerKeyStates;
import lehjr.numina.common.capabilities.player.keystates.PlayerKeyStateStorage;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ByteTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerKeyStateWrapper
implements ICapabilitySerializable<ByteTag> {
    Player player;
    private final PlayerKeyStateStorage keyStateStorage;
    private final LazyOptional<IPlayerKeyStates> keyStateCap;

    public PlayerKeyStateWrapper(Player player) {
        this.player = player;
        this.keyStateStorage = new PlayerKeyStateStorage();
        this.keyStateCap = LazyOptional.of(() -> this.keyStateStorage);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        LazyOptional playerKeyStates = NuminaCapabilities.PLAYER_KEYSTATES.orEmpty(cap, this.keyStateCap);
        if (playerKeyStates.isPresent()) {
            return playerKeyStates;
        }
        return LazyOptional.empty();
    }

    public ByteTag serializeNBT() {
        return this.keyStateStorage.serializeNBT();
    }

    public void deserializeNBT(ByteTag nbt) {
        this.keyStateStorage.deserializeNBT(nbt);
    }
}

