/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.render.modelspec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public final class MorphTarget
extends Enum<MorphTarget> {
    public static final /* enum */ MorphTarget Hat = new MorphTarget("hat", EquipmentSlot.HEAD);
    public static final /* enum */ MorphTarget Head = new MorphTarget("head", EquipmentSlot.HEAD);
    public static final /* enum */ MorphTarget Body = new MorphTarget("body", EquipmentSlot.CHEST);
    public static final /* enum */ MorphTarget RightArm = new MorphTarget("right_arm", EquipmentSlot.CHEST);
    public static final /* enum */ MorphTarget LeftArm = new MorphTarget("left_arm", EquipmentSlot.CHEST);
    public static final /* enum */ MorphTarget RightLeg = new MorphTarget("right_leg", EquipmentSlot.LEGS);
    public static final /* enum */ MorphTarget LeftLeg = new MorphTarget("left_leg", EquipmentSlot.LEGS);
    public static final /* enum */ MorphTarget RightFoot = new MorphTarget("right_foot", EquipmentSlot.FEET);
    public static final /* enum */ MorphTarget LeftFoot = new MorphTarget("left_foot", EquipmentSlot.FEET);
    public static final /* enum */ MorphTarget MainHand = new MorphTarget("main_hand", EquipmentSlot.MAINHAND);
    public static final /* enum */ MorphTarget OffHand = new MorphTarget("off_hand", EquipmentSlot.OFFHAND);
    public static final /* enum */ MorphTarget RightHand = new MorphTarget("right_hand", EquipmentSlot.MAINHAND);
    public static final /* enum */ MorphTarget Lefthand = new MorphTarget("left_hand", EquipmentSlot.OFFHAND);
    public static final /* enum */ MorphTarget AnyHand = new MorphTarget("any_hand", EquipmentSlot.MAINHAND);
    String name;
    EquipmentSlot slot;
    private static final /* synthetic */ MorphTarget[] $VALUES;

    public static MorphTarget[] values() {
        return (MorphTarget[])$VALUES.clone();
    }

    public static MorphTarget valueOf(String name) {
        return Enum.valueOf(MorphTarget.class, name);
    }

    private MorphTarget(String name, EquipmentSlot slots) {
        this.name = name;
        this.slot = slots;
    }

    public static MorphTarget getMorph(String name) {
        return Arrays.stream(MorphTarget.values()).filter(morph -> name.toLowerCase().equals(morph.name)).findAny().orElseGet(null);
    }

    public HumanoidArm getHandFromEquipmentSlot(LivingEntity entity) {
        assert (this.slot.m_20743_() != EquipmentSlot.Type.ARMOR);
        switch (this) {
            case MainHand: {
                return entity.m_5737_();
            }
            case OffHand: {
                return entity.m_5737_().m_20828_();
            }
            case Lefthand: {
                return HumanoidArm.LEFT;
            }
        }
        return HumanoidArm.RIGHT;
    }

    public boolean handMatches(LivingEntity entity, EquipmentSlot slot) {
        if (slot.m_20743_() != EquipmentSlot.Type.ARMOR && this.slot.m_20743_() != EquipmentSlot.Type.ARMOR) {
            if (this.equals((Object)MainHand) || this.equals((Object)OffHand)) {
                return slot.equals((Object)this.slot);
            }
            if (this.equals((Object)AnyHand)) {
                return true;
            }
            HumanoidArm arm = slot.equals((Object)EquipmentSlot.MAINHAND) ? entity.m_5737_() : entity.m_5737_().m_20828_();
            return this.getHandFromEquipmentSlot(entity) == arm;
        }
        return false;
    }

    public static List<MorphTarget> getMorphTargetsFromEquipmentSlot(EquipmentSlot slot) {
        switch (slot) {
            case HEAD: {
                return Arrays.asList(Head);
            }
            case CHEST: {
                return Arrays.asList(Body, LeftArm, RightArm);
            }
            case LEGS: {
                return Arrays.asList(LeftLeg, RightLeg);
            }
            case FEET: {
                return Arrays.asList(LeftFoot, RightFoot);
            }
        }
        return new ArrayList<MorphTarget>();
    }

    public ModelPart apply(HumanoidModel m) {
        switch (this) {
            case Hat: 
            case Head: {
                return m.f_102808_;
            }
            case Body: {
                return m.f_102810_;
            }
            case RightHand: 
            case RightArm: {
                return m.f_102811_;
            }
            case Lefthand: 
            case LeftArm: {
                return m.f_102812_;
            }
            case RightFoot: 
            case RightLeg: {
                return m.f_102813_;
            }
            case LeftFoot: 
            case LeftLeg: {
                return m.f_102814_;
            }
        }
        return null;
    }

    private static /* synthetic */ MorphTarget[] $values() {
        return new MorphTarget[]{Hat, Head, Body, RightArm, LeftArm, RightLeg, LeftLeg, RightFoot, LeftFoot, MainHand, OffHand, RightHand, Lefthand, AnyHand};
    }

    static {
        $VALUES = MorphTarget.$values();
    }
}

